/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.secretstore.aws;

import io.confluent.csid.config.provider.aws.SecretsManagerConfigProvider;
import io.confluent.gateway.common.secretprovider.aws.AwsSecretStoreConfig;
import io.confluent.gateway.filter.authswap.secretstore.Credential;
import io.confluent.gateway.filter.authswap.secretstore.SecretStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigData;

public class AwsSecretStore
implements SecretStore<AwsSecretStoreConfig> {
    private final SecretsManagerConfigProvider provider = this.createSecretsManagerConfigProvider();
    private AwsSecretStoreConfig config;

    private SecretsManagerConfigProvider createSecretsManagerConfigProvider() {
        return new SecretsManagerConfigProvider();
    }

    @Override
    public String getType() {
        return "AWS";
    }

    @Override
    public Credential exchangeCredential(Credential credential) {
        String username = credential.username();
        ConfigData configData = this.provider.get(username, new HashSet<String>(Collections.singletonList(username)));
        String password = (String)configData.data().get(username);
        return this.getCredentialFrom(password, this.getSeparator(this.config));
    }

    @Override
    public void configure(AwsSecretStoreConfig config) {
        this.config = config;
        this.provider.configure(config.toMap());
    }

    @Override
    public String getSeparator(AwsSecretStoreConfig config) {
        return Optional.ofNullable(config.separator()).orElse(":");
    }
}

