/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;

public final class ConfigUtil {
    private ConfigUtil() {
        throw new AssertionError((Object)"ConfigUtil class should not be instantiated");
    }

    public static <T extends Number> T defaultIfNullOrNonPositive(T value, T defaultValue) {
        return (T)Optional.ofNullable(value).filter(v -> v.longValue() > 0L).orElse(defaultValue);
    }

    public static <T extends Number> T defaultIfNullOrNegative(T value, T defaultValue) {
        return (T)Optional.ofNullable(value).filter(v -> v.longValue() >= 0L).orElse(defaultValue);
    }

    public static String defaultIfNullOrEmpty(String value, String defaultValue) {
        return Optional.ofNullable(value).filter(v -> !v.trim().isEmpty()).orElse(defaultValue);
    }

    public static Boolean defaultIfNull(Boolean value, Boolean defaultValue) {
        return Optional.ofNullable(value).orElse(defaultValue);
    }

    public static String readFileContent(String filePath) {
        try {
            return Files.readString(Paths.get(filePath, new String[0]));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read file: " + filePath, e);
        }
    }
}

