/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.utils;

import io.confluent.gateway.filter.authswap.config.ClientAuth;
import io.confluent.gateway.filter.authswap.config.ClusterAuth;
import io.confluent.gateway.filter.authswap.config.SaslServer;
import io.confluent.gateway.filter.authswap.secretstore.Credential;
import io.confluent.gateway.filter.authswap.utils.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.authenticator.SaslClientCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginUtil.class);

    private LoginUtil() {
        throw new AssertionError((Object)"LoginUtil class should not be instantiated");
    }

    public static String createJaasConfig(AuthenticateCallbackHandler handler, Credential credential, ClusterAuth clusterAuth) {
        try {
            String jaasTemplate = ConfigUtil.readFileContent(clusterAuth.sasl().jaasConfig().file());
            if (handler instanceof OAuthBearerLoginCallbackHandler) {
                return String.format(jaasTemplate, credential.username(), credential.password().map(Password::value).orElse(""));
            }
            if (handler instanceof SaslClientCallbackHandler) {
                return String.format(jaasTemplate, credential.username(), credential.password().map(Password::value).orElse(""));
            }
            throw new IllegalArgumentException("Unsupported callback handler type: " + handler.getClass().getName());
        }
        catch (Exception e) {
            LOGGER.error("Failed to create JAAS config: {}", (Object)clusterAuth.sasl().jaasConfig().file(), (Object)e);
            throw new IllegalArgumentException("Failed to create JAAS config: " + clusterAuth.sasl().jaasConfig().file(), e);
        }
    }

    public static Map<String, Object> createLoginSaslConfigMap(String jaasConfig, ClusterAuth clusterAuth, AuthenticateCallbackHandler callbackHandler) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("sasl.jaas.config", new Password(jaasConfig));
        configs.putAll(clusterAuth.toSaslConfigMap(callbackHandler));
        return configs;
    }

    public static Map<String, ?> createValidatorSaslConfigMap(ClientAuth config, AuthenticateCallbackHandler callbackHandler) {
        return config.toSaslConfigMap(callbackHandler);
    }

    public static List<AppConfigurationEntry> getValidatorAppConfigurationEntry(SaslServer saslServer) {
        JaasContext jaasContext = saslServer.jaasConfig().loadJaasContext(saslServer.mechanism());
        return jaasContext.configurationEntries();
    }
}

