/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.aws;

import io.confluent.csid.config.provider.annotations.CodeBlock;
import io.confluent.csid.config.provider.annotations.ConfigProviderKey;
import io.confluent.csid.config.provider.annotations.Description;
import io.confluent.csid.config.provider.annotations.DocumentationSection;
import io.confluent.csid.config.provider.annotations.DocumentationSections;
import io.confluent.csid.config.provider.annotations.DocumentationTip;
import io.confluent.csid.config.provider.aws.SecretsManagerConfigProviderConfig;
import io.confluent.csid.config.provider.aws.SecretsManagerFactory;
import io.confluent.csid.config.provider.aws.SecretsManagerFactoryImpl;
import io.confluent.csid.config.provider.common.AbstractJacksonConfigProvider;
import io.confluent.csid.config.provider.common.SecretRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

@Description(value="This config provider is used to retrieve secrets from the AWS Secrets Manager service.")
@DocumentationSections(sections={@DocumentationSection(title="Secret Value", text="The value for the secret must be formatted as a JSON object. This allows multiple keys of data to be stored in a single secret. The name of the secret in AWS Secrets Manager will correspond to the path that is requested by the config provider.", codeblocks={@CodeBlock(title="Example Secret Value", language="json", text="{\n  \"username\" : \"appdbsecret\",\n  \"password\" : \"u$3@b3tt3rp@$$w0rd\"\n}")})})
@DocumentationTip(value="Config providers can be used with anything that supports the AbstractConfig base class that is shipped with Apache Kafka.")
@ConfigProviderKey(value="secretsManager")
public class SecretsManagerConfigProvider
extends AbstractJacksonConfigProvider<SecretsManagerConfigProviderConfig> {
    private static final Logger log = LoggerFactory.getLogger(SecretsManagerConfigProvider.class);
    SecretsManagerFactory secretsManagerFactory = new SecretsManagerFactoryImpl();
    SecretsManagerClient secretsManager;

    protected SecretsManagerConfigProviderConfig config(Map<String, ?> settings) {
        return new SecretsManagerConfigProviderConfig(settings);
    }

    protected void configure() {
        super.configure();
        this.secretsManager = this.secretsManagerFactory.create((SecretsManagerConfigProviderConfig)this.config);
    }

    protected Map<String, String> getSecret(SecretRequest secretRequest) throws Exception {
        GetSecretValueRequest.Builder builder = GetSecretValueRequest.builder();
        secretRequest.version().ifPresent(arg_0 -> ((GetSecretValueRequest.Builder)builder).versionId(arg_0));
        builder.secretId(null == ((SecretsManagerConfigProviderConfig)this.config).prefix ? secretRequest.path() : ((SecretsManagerConfigProviderConfig)this.config).prefix + secretRequest.path());
        GetSecretValueRequest request = (GetSecretValueRequest)builder.build();
        log.trace("getSecret() - request = {}", (Object)request);
        GetSecretValueResponse result = this.secretsManager.getSecretValue(request);
        String secretString = result.secretString();
        if (null == secretString) {
            SdkBytes secretBinary = result.secretBinary();
            if (secretBinary == null) {
                throw new ConfigException("Secret " + request.secretId() + " contained neither secretString nor secretBinary.");
            }
            secretString = StandardCharsets.UTF_8.decode(result.secretBinary().asByteBuffer()).toString();
        }
        return ((SecretsManagerConfigProviderConfig)this.config).isJsonSecret() ? this.readJsonValue(secretString) : Map.of(secretRequest.path(), secretString);
    }

    public void close() throws IOException {
        if (null != this.secretsManager) {
            this.secretsManager.close();
            this.secretsManagerFactory.closeDefaultCredentials();
        }
        super.close();
    }

    public ConfigDef config() {
        return SecretsManagerConfigProviderConfig.config();
    }
}

