/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.aws;

import io.confluent.csid.config.provider.aws.SecretsManagerConfigProviderConfig;
import io.confluent.csid.config.provider.aws.SecretsManagerFactory;
import java.net.URI;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

class SecretsManagerFactoryImpl
implements SecretsManagerFactory {
    private DefaultCredentialsProvider defaultCredentialsProvider;

    SecretsManagerFactoryImpl() {
    }

    @Override
    public SecretsManagerClient create(SecretsManagerConfigProviderConfig config) {
        SecretsManagerClientBuilder builder = this.configure(config);
        return (SecretsManagerClient)builder.build();
    }

    @Override
    public void closeDefaultCredentials() {
        if (null != this.defaultCredentialsProvider) {
            this.defaultCredentialsProvider.close();
        }
    }

    protected SecretsManagerClientBuilder configure(SecretsManagerConfigProviderConfig config) {
        SecretsManagerClientBuilder builder = SecretsManagerClient.builder();
        if (null != config.region && !config.region.isEmpty()) {
            builder = (SecretsManagerClientBuilder)builder.region(Region.of((String)config.region));
        }
        if (null != config.endpointOverride && !config.endpointOverride.isEmpty()) {
            builder = (SecretsManagerClientBuilder)builder.endpointOverride(URI.create(config.endpointOverride));
        }
        if (config.credentials instanceof AwsBasicCredentials) {
            builder = (SecretsManagerClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)config.credentials));
        } else {
            this.defaultCredentialsProvider = DefaultCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true)).build();
            builder = (SecretsManagerClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)this.defaultCredentialsProvider);
        }
        return builder;
    }
}

