/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config.secret;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kroxylicious.proxy.config.secret.PasswordProvider;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public record FilePassword(@JsonProperty(required=true) String passwordFile) implements PasswordProvider
{
    public FilePassword {
        Objects.requireNonNull(passwordFile);
    }

    @Override
    public String getProvidedPassword() {
        return FilePassword.readPasswordFile(this.passwordFile);
    }

    @Override
    public String toString() {
        return "FilePassword[passwordFile=" + this.passwordFile + "]";
    }

    static String readPasswordFile(String passwordFile) {
        String string;
        BufferedReader fr = new BufferedReader(new FileReader(passwordFile, StandardCharsets.UTF_8));
        try {
            String line = fr.readLine();
            if (line == null) {
                throw new IOException("Empty file");
            }
            string = line;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Exception reading " + passwordFile, e);
            }
        }
        fr.close();
        return string;
    }
}

