/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.common.util;

import java.net.IDN;
import java.util.regex.Pattern;

public final class HostPortValidator {
    private static final Pattern PORT_PATTERN = Pattern.compile("^[0-9]{1,5}$");
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(?:\\d{1,3}\\.){3}\\d{1,3}$");
    private static final Pattern IPV6_HEX_PATTERN = Pattern.compile("^[0-9a-fA-F:.]+$");
    private static final Pattern DNS_ASCII_LABEL = Pattern.compile("^[A-Za-z0-9](?:[A-Za-z0-9-]{0,61}[A-Za-z0-9])?$");

    private HostPortValidator() {
    }

    public static void validate(String endpoint) throws IllegalArgumentException {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint is null");
        }
        Parsed parsed = HostPortValidator.parseEndpoint(endpoint);
        HostPortValidator.validatePort(parsed.port);
        if (parsed.isIpv6Literal) {
            return;
        }
        if (HostPortValidator.isValidIpv4(parsed.host)) {
            return;
        }
        HostPortValidator.validateDns(parsed.host);
    }

    private static void validatePort(String portPart) {
        int port;
        if (portPart == null || portPart.isEmpty()) {
            HostPortValidator.fail("Port is empty");
        }
        if (!PORT_PATTERN.matcher(portPart).matches()) {
            HostPortValidator.fail("Port must be numeric");
        }
        if ((port = Integer.parseInt(portPart)) < 1 || port > 65535) {
            HostPortValidator.fail("Port out of range: " + port);
        }
    }

    private static boolean isValidIpv4(String host) {
        return IPV4_PATTERN.matcher(host).matches();
    }

    private static void validateDns(String host) {
        String ascii;
        try {
            ascii = IDN.toASCII(host, 1);
        }
        catch (IllegalArgumentException ex) {
            HostPortValidator.fail("Invalid internationalised domain name: " + ex.getMessage());
            return;
        }
        for (String label : ascii.split("\\.")) {
            if (DNS_ASCII_LABEL.matcher(label).matches()) continue;
            HostPortValidator.fail("Illegal DNS label: " + label);
        }
        if (ascii.contains("..")) {
            HostPortValidator.fail("Consecutive dots are not allowed in DNS names");
        }
    }

    private static Parsed parseEndpoint(String endpoint) {
        if (endpoint.startsWith("[")) {
            String host;
            int close = endpoint.indexOf(93);
            if (close < 0 || close >= endpoint.length() - 1 || endpoint.charAt(close + 1) != ':') {
                HostPortValidator.fail("IPv6 literal must be [addr]:port");
            }
            if (!IPV6_HEX_PATTERN.matcher(host = endpoint.substring(1, close)).matches()) {
                HostPortValidator.fail("Invalid IPv6 literal");
            }
            String port = endpoint.substring(close + 2);
            return new Parsed(host, port, true);
        }
        int colon = endpoint.lastIndexOf(58);
        if (colon < 1 || colon == endpoint.length() - 1) {
            HostPortValidator.fail("Endpoint must be <host>:<port>");
        }
        String host = endpoint.substring(0, colon);
        String port = endpoint.substring(colon + 1);
        return new Parsed(host, port, false);
    }

    private static void fail(String message) {
        throw new IllegalArgumentException("Invalid endpoint format: " + message);
    }

    record Parsed(String host, String port, boolean isIpv6Literal) {
    }
}

