/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.vault;

import io.confluent.csid.config.provider.vault.AuthHandler;
import io.confluent.csid.config.provider.vault.AuthMethod;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class AuthHandlers {
    static final Map<AuthMethod, AuthHandler> HANDLER_MAP;

    AuthHandlers() {
    }

    public static AuthHandler get(AuthMethod method) {
        return HANDLER_MAP.get((Object)method);
    }

    static {
        Map<AuthMethod, AuthHandler> handlers = Stream.of(new AuthHandler.Token(), new AuthHandler.LDAP(), new AuthHandler.UserPass(), new AuthHandler.Certificate(), new AuthHandler.AppRole()).collect(Collectors.toMap(AuthHandler::method, a -> a));
        HANDLER_MAP = Collections.unmodifiableMap(handlers);
    }
}

