/*
 * Copyright 2025 Confluent Inc.
 */

package io.confluent.gateway.filter.authswap.response;

import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

<#list imports as import>
import ${import};
</#list>

import java.util.Optional;
import java.util.Map;
import java.util.HashMap;

/**
 * Generated class containing error response creators for simple APIs.
 *
 * <p>Simple APIs are those that have ErrorCode at the top level of their response schema.
 *
 * <p>This class is automatically generated from Kafka response classes using reflection.
 * It provides direct method calls for optimal performance (no reflection overhead at runtime).
 *
 * <p>DO NOT EDIT MANUALLY - Generated by SimpleApiCodeGenerator
 */
@SuppressWarnings({"ClassDataAbstractionCoupling", "MethodLength", "JavaNCSS", "JavadocParagraph", "LineLength"})
public class SimpleApiErrorCreators {

  private static final Logger LOGGER = LoggerFactory.getLogger(SimpleApiErrorCreators.class);

  private static final String SET_MESSAGE_NOT_FOUND_ERROR = 
          "{} response does not support setting error messages but received: {}";

  /**
   * Returns a map of all simple API error creators.
   *
   * <p>This can be used to bulk register all simple APIs with ERROR_CREATORS.putAll().
   *
   * @return Map of ApiKeys to ErrorResponseBuilder for all simple APIs
   */
  @SuppressWarnings({"MethodLength", "JavaNCSS"})
  public static Map<ApiKeys, ErrorResponseBuilder> getAllErrorResponses() {
    Map<ApiKeys, ErrorResponseBuilder> errorCreators = new HashMap<>();
    
<#list apis as api>
    // ${api.apiKey.name()} - ErrorCode: ${api.hasErrorCode()?c}, ErrorMessage: ${api.hasErrorMessage()?c}
    errorCreators.put(ApiKeys.${api.apiKey.name()}, 
        (apiKey, request, errorCode, errorMessage) -> 
            create${api.methodName}ErrorResponse(errorCode, errorMessage));
    
</#list>
    return errorCreators;
  }

<#list apis as api>
  /**
   * Creates error response for ${api.apiKey.name()}.
   *
   * <p>Schema analysis: ErrorCode=${api.hasErrorCode()?c}, ErrorMessage=${api.hasErrorMessage()?c}
   *
   * @param errorCode the error code to set
   * @param errorMessage the error message to set (may be null)
   * @return Optional containing the error response
   */
  public static Optional<ApiMessage> create${api.methodName}ErrorResponse(
          short errorCode, String errorMessage) {
    ${api.simpleClassName} response = new ${api.simpleClassName}()
            .setErrorCode(errorCode);

<#if api.hasErrorMessage()>
    if (errorMessage != null) {
      response.setErrorMessage(errorMessage);
    }
<#else>
    if (errorMessage != null) {
      LOGGER.info(SET_MESSAGE_NOT_FOUND_ERROR, ApiKeys.${api.apiKey.name()}, errorMessage);
    }
</#if>

    return Optional.of(response);
  }

</#list>
}
