# Gateway

Gateway is a Kafka proxy component of Confluent Private Cloud (CPC) that acts as an intermediary between Kafka clients and brokers which is built on the [Kroxylicious](https://kroxylicious.io/) framework.
## Modules

- **`gateway-app/`** - Main application module containing the gateway runtime
- **`gateway-common/`** - Common utilities and shared code used across the gateway
- **`gateway-filters/`** - Filter implementations (eg:- AuthSwapFilter for authentication swap)
- **`gateway-jacoco-aggregate/`** - Code coverage aggregation module
- **`gateway-integration-test-tool/`** - Integration test utilities for testing
- **`gateway-docker/`** - Docker image build and configuration for the gateway
- **`gateway-performance-tests/`** - Gateway Performance Benchmarking with OMB Framework automation module
- **`gateway-metrics-dashboard/`** - Docker compose for Prometheus and Grafana dashboard for monitoring gateway metrics

## Build & Run

### Build
```bash
# Build with Maven
mvn clean package -DskipTests

# Or use the setup script
./build-and-setup.sh
```

### Test
```bash
# Run all tests
mvn test

# Run only unit tests (fast)
mvn test -Dtest="*Test"

# Run only integration tests  
mvn test -Dtest="*IntegrationTest"

# Run a specific integration test (using failsafe plugin)
mvn -pl gateway-app failsafe:integration-test -Dit.test=ClassName\$NestedClass#methodName
# Example: mvn -pl gateway-app failsafe:integration-test -Dit.test=GatewayAuthSwapIntegrationTest\$PlainToPlainAuthSwapTests#testAuthSwapPlainToPlainWithKafkaConnectionReauth
```

#### Locally Run Tests
Leverage `.run/` configuration to run just unit-tests or just integration-tests inside intellij.

## Useful Scripts

- **`build-and-setup.sh`** - Automated build and setup script with dependency checks
- **`bin/gateway`** - Main gateway startup script
- **`bin/gateway-run-class`** - Generic launcher with classpath management
- **`bin/setup.sh`** - Makes scripts executable and sets up the environment

See `bin/README.md` for detailed script usage and configuration options.

## Requirements

- Java 17+
- Maven 3.6+
