/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap;

import io.kroxylicious.proxy.filter.FilterContext;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger LOGGER = LoggerFactory.getLogger(Session.class);
    private Boolean clusterConnectionEstablished = false;
    private Long clientToGatewaySessionLifetimeEpochMs;
    private Long gatewayToClusterSessionLifetimeMs;
    private long gatewayToClusterSessionStartTime;
    private long clientToGatewaySessionStartTime;

    public long getGatewayToClusterSessionLifetimeMs() {
        return this.gatewayToClusterSessionLifetimeMs;
    }

    public void updateClientToGatewaySession(Long sessionLifetimeMs) {
        this.clientToGatewaySessionLifetimeEpochMs = sessionLifetimeMs;
        this.clientToGatewaySessionStartTime = System.currentTimeMillis();
    }

    public void updateGatewayToClusterSession(Long sessionLifetimeMs) {
        this.gatewayToClusterSessionLifetimeMs = sessionLifetimeMs;
        this.gatewayToClusterSessionStartTime = System.currentTimeMillis();
        this.clusterConnectionEstablished = true;
    }

    public boolean shouldGatewayReauthenticate() {
        long nextReauthTime;
        if (this.gatewayToClusterSessionLifetimeMs == null || this.gatewayToClusterSessionLifetimeMs == 0L) {
            return false;
        }
        long elapsedTime = this.getGatewayToClusterElapsedTime();
        return elapsedTime >= (nextReauthTime = this.getNextReauthTime());
    }

    public boolean shouldClientReauthenticate() {
        if (this.clientToGatewaySessionLifetimeEpochMs == null || this.clientToGatewaySessionLifetimeEpochMs == 0L) {
            return false;
        }
        return System.currentTimeMillis() >= this.clientToGatewaySessionLifetimeEpochMs;
    }

    public long calculateRemainingSessionTimeMs(Long connectionsMaxReauthMs, FilterContext context) {
        boolean maxReauthConfigured;
        long remainingSessionTimeMs = 0L;
        long currentTimeMs = System.currentTimeMillis();
        long currentTimeMsNanos = System.nanoTime();
        Long sessionExpirationTimeNanos = null;
        boolean bl = maxReauthConfigured = connectionsMaxReauthMs != null && connectionsMaxReauthMs > 0L;
        if (this.clientToGatewaySessionLifetimeEpochMs != null || maxReauthConfigured) {
            if (this.clientToGatewaySessionLifetimeEpochMs == null) {
                remainingSessionTimeMs = this.zeroIfNegative(connectionsMaxReauthMs);
                this.clientToGatewaySessionLifetimeEpochMs = currentTimeMs + remainingSessionTimeMs;
            } else {
                remainingSessionTimeMs = !maxReauthConfigured ? this.zeroIfNegative(this.clientToGatewaySessionLifetimeEpochMs - currentTimeMs) : this.zeroIfNegative(Math.min(this.clientToGatewaySessionLifetimeEpochMs - currentTimeMs, connectionsMaxReauthMs));
            }
            sessionExpirationTimeNanos = currentTimeMsNanos + 1000000L * remainingSessionTimeMs;
        }
        if (this.clientToGatewaySessionLifetimeEpochMs != null) {
            LOGGER.debug("Session max lifetime from broker config={} ms, credential expiration={} ({} ms); session expiration = {} ({} ms),  sending {} ms to client for channel: {}", new Object[]{connectionsMaxReauthMs, new Date(this.clientToGatewaySessionLifetimeEpochMs), this.clientToGatewaySessionLifetimeEpochMs - currentTimeMs, new Date(currentTimeMs + remainingSessionTimeMs), remainingSessionTimeMs, remainingSessionTimeMs, context.channelDescriptor()});
        } else if (sessionExpirationTimeNanos != null) {
            LOGGER.debug("Session max lifetime from broker config={} ms, no credential expiration; session expiration = {} ({} ms),  sending {} ms to client for channel: {}", new Object[]{connectionsMaxReauthMs, new Date(currentTimeMs + remainingSessionTimeMs), remainingSessionTimeMs, remainingSessionTimeMs, context.channelDescriptor()});
        } else {
            LOGGER.debug("Session max lifetime from broker config={} ms, no credential expiration; no session expiration, sending 0 ms to client for channel: {}", (Object)connectionsMaxReauthMs, (Object)context.channelDescriptor());
        }
        return remainingSessionTimeMs;
    }

    private long zeroIfNegative(long value) {
        return Math.max(0L, value);
    }

    private long getGatewayToClusterElapsedTime() {
        return System.currentTimeMillis() - this.gatewayToClusterSessionStartTime;
    }

    private long getClientToGatewayElapsedTime() {
        return System.currentTimeMillis() - this.clientToGatewaySessionStartTime;
    }

    private long getNextReauthTime() {
        return (long)((double)this.gatewayToClusterSessionLifetimeMs.longValue() * 0.8);
    }

    public Boolean isClusterConnectionEstablished() {
        return this.clusterConnectionEstablished;
    }
}

