/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.client;

import io.confluent.gateway.filter.authswap.Session;
import io.confluent.gateway.filter.authswap.client.ClientAuthProcessor;
import io.confluent.gateway.filter.authswap.metrics.AuthMetricsRecorder;
import org.apache.kafka.common.protocol.ApiKeys;

public abstract class AbstractClientAuthProcessor
implements ClientAuthProcessor {
    protected String incomingClientId;
    protected final Session session;
    protected final AuthMetricsRecorder recorder;

    protected AbstractClientAuthProcessor(Session session, AuthMetricsRecorder recorder) {
        this.session = session;
        this.recorder = recorder;
    }

    @Override
    public String getIncomingClientId() {
        return this.incomingClientId;
    }

    protected void setIncomingClientId(String clientId) {
        this.incomingClientId = clientId;
    }

    @Override
    public final boolean shouldHandleRequest(ApiKeys apiKey, short apiVersion) {
        if (apiKey == ApiKeys.API_VERSIONS) {
            return false;
        }
        return this.shouldInterceptForAuthentication(apiKey, apiVersion) || this.shouldInterceptForReAuthentication(apiKey, apiVersion);
    }

    protected abstract boolean shouldInterceptForAuthentication(ApiKeys var1, short var2);

    protected abstract boolean shouldInterceptForReAuthentication(ApiKeys var1, short var2);

    protected boolean isClusterConnectionEstablished() {
        return this.session.isClusterConnectionEstablished();
    }
}

