/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.client;

import io.confluent.gateway.filter.authswap.Session;
import io.confluent.gateway.filter.authswap.client.ClientAuthProcessor;
import io.confluent.gateway.filter.authswap.client.MtlsClientAuthProcessor;
import io.confluent.gateway.filter.authswap.client.NoneClientAuthProcessor;
import io.confluent.gateway.filter.authswap.client.SaslClientAuthProcessor;
import io.confluent.gateway.filter.authswap.config.AuthSwapFilterConfig;
import io.confluent.gateway.filter.authswap.config.ClientAuth;
import io.confluent.gateway.filter.authswap.metrics.AuthMetricsRecorder;

public class ClientAuthProcessorFactory {
    public static ClientAuthProcessor createClientAuthProcessor(AuthSwapFilterConfig config, Session session, AuthMetricsRecorder recorder) {
        ClientAuth clientAuth = config.config().clientAuth();
        if (clientAuth.sasl() != null) {
            return new SaslClientAuthProcessor(config, session, recorder);
        }
        if (clientAuth.ssl() != null) {
            return new MtlsClientAuthProcessor(session, recorder, clientAuth.ssl());
        }
        if (clientAuth.none() != null) {
            return new NoneClientAuthProcessor(session, recorder);
        }
        throw new IllegalArgumentException("No valid auth swap strategy configured");
    }
}

