/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.client;

import io.confluent.gateway.filter.authswap.Session;
import io.confluent.gateway.filter.authswap.client.AbstractClientAuthProcessor;
import io.confluent.gateway.filter.authswap.client.AuthResult;
import io.confluent.gateway.filter.authswap.metrics.AuthMetricsRecorder;
import io.kroxylicious.proxy.filter.FilterContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoneClientAuthProcessor
extends AbstractClientAuthProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoneClientAuthProcessor.class);
    private static final String ANONYMOUS = "ANONYMOUS";

    public NoneClientAuthProcessor(Session session, AuthMetricsRecorder recorder) {
        super(session, recorder);
    }

    @Override
    public CompletionStage<AuthResult> authenticate(ApiKeys apiKey, RequestHeaderData header, ApiMessage request, FilterContext context) {
        if (apiKey == ApiKeys.SASL_HANDSHAKE || apiKey == ApiKeys.SASL_AUTHENTICATE) {
            LOGGER.warn("SASL requests are not supported in no-auth mode for channel: {}", (Object)context.channelDescriptor());
            this.recorder.incrementClientAuthFailure(context.getVirtualClusterName());
            return CompletableFuture.completedStage(AuthResult.failure(new IllegalStateException("SASL authentication is not supported in no-auth mode"), Errors.UNSUPPORTED_SASL_MECHANISM.code()));
        }
        this.setIncomingClientId(ANONYMOUS);
        this.recorder.incrementAnonymousClient(context.getVirtualClusterName());
        this.recorder.incrementClientAuthSuccess(context.getVirtualClusterName());
        LOGGER.debug("No-auth processor setting anonymous client for channel: {}", (Object)context.channelDescriptor());
        return CompletableFuture.completedStage(AuthResult.success(ANONYMOUS));
    }

    @Override
    protected boolean shouldInterceptForAuthentication(ApiKeys apiKey, short apiVersion) {
        if (apiKey == ApiKeys.SASL_HANDSHAKE || apiKey == ApiKeys.SASL_AUTHENTICATE) {
            return true;
        }
        return !this.isClusterConnectionEstablished();
    }

    @Override
    protected boolean shouldInterceptForReAuthentication(ApiKeys apiKey, short apiVersion) {
        return false;
    }
}

