/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.filter.authswap.utils.ConfigUtil;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public record OauthServerConfig(@JsonProperty(required=true) URI jwksEndpointUrl, @JsonProperty Long jwksEndpointRefreshMs, @JsonProperty Long jwksEndpointRetryBackoffMs, @JsonProperty Long jwksEndpointRetryBackoffMaxMs, @JsonProperty String scopeClaimName, @JsonProperty String subClaimName, @JsonProperty String expectedAudience, @JsonProperty String expectedIssuer) {
    public static OauthServerConfig withDefaults(OauthServerConfig config) {
        return new OauthServerConfig(config.jwksEndpointUrl(), ConfigUtil.defaultIfNullOrNegative(config.jwksEndpointRefreshMs(), 3600000L), ConfigUtil.defaultIfNullOrNegative(config.jwksEndpointRetryBackoffMs(), 100L), ConfigUtil.defaultIfNullOrNonPositive(config.jwksEndpointRetryBackoffMaxMs(), 10000L), ConfigUtil.defaultIfNullOrEmpty(config.scopeClaimName(), "scope"), ConfigUtil.defaultIfNullOrEmpty(config.subClaimName(), "sub"), config.expectedAudience(), config.expectedIssuer());
    }

    public boolean isValid() {
        return this.jwksEndpointUrl != null;
    }

    public Map<String, Object> toValidatorSaslConfigMap() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("sasl.oauthbearer.jwks.endpoint.url", this.jwksEndpointUrl.toString());
        configMap.put("sasl.oauthbearer.jwks.endpoint.refresh.ms", this.jwksEndpointRefreshMs);
        configMap.put("sasl.oauthbearer.jwks.endpoint.retry.backoff.ms", this.jwksEndpointRetryBackoffMs);
        configMap.put("sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms", this.jwksEndpointRetryBackoffMaxMs);
        configMap.put("sasl.oauthbearer.scope.claim.name", this.scopeClaimName);
        configMap.put("sasl.oauthbearer.sub.claim.name", this.subClaimName);
        if (this.expectedAudience != null) {
            List<String> audience = Arrays.stream(this.expectedAudience.split(",")).map(String::trim).filter(element -> !element.isEmpty()).toList();
            configMap.put("sasl.oauthbearer.expected.audience", audience);
        }
        if (this.expectedIssuer != null) {
            configMap.put("sasl.oauthbearer.expected.issuer", this.expectedIssuer);
        }
        return configMap;
    }
}

