/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.filter.authswap.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.gateway.filter.authswap.config.JaasConfig;
import io.confluent.gateway.filter.authswap.config.OauthClientConfig;
import io.confluent.gateway.filter.authswap.config.SupportedSaslMechanism;
import io.confluent.gateway.filter.authswap.utils.ConfigUtil;
import io.kroxylicious.proxy.plugin.PluginConfigurationException;
import org.apache.commons.lang3.StringUtils;

public record SaslClient(@JsonProperty(required=true) String callbackHandlerClass, @JsonProperty(required=true) String mechanism, @JsonProperty(required=true) JaasConfig jaasConfig, @JsonProperty OauthClientConfig oauth, @JsonProperty Long loginRetryBackoffMs, @JsonProperty Long loginRetryBackoffMaxMs, @JsonProperty Double refreshWindowFactor, @JsonProperty Double refreshWindowJitter, @JsonProperty Short refreshMinPeriodSeconds, @JsonProperty Short refreshBufferSeconds) {
    public SaslClient {
        if (!SupportedSaslMechanism.isValidMechanism(mechanism)) {
            throw new PluginConfigurationException("SASL mechanism must be one of: " + String.join((CharSequence)", ", SupportedSaslMechanism.all()));
        }
        if (jaasConfig == null) {
            throw new PluginConfigurationException("jaasConfig must not be null");
        }
        String content = ConfigUtil.readFileContent(jaasConfig.file());
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new PluginConfigurationException("JAAS config file content must not be empty");
        }
        if (StringUtils.equals((CharSequence)SupportedSaslMechanism.OAUTHBEARER.getMechanism(), (CharSequence)mechanism)) {
            if (oauth == null) {
                throw new PluginConfigurationException("OauthConfig must be provided for OAUTHBEARER mechanism");
            }
            if (!oauth.isValid()) {
                throw new PluginConfigurationException("Token Endpoint URL is required for ClusterAuth when using OAUTHBEARER mechanism");
            }
        }
    }

    public static SaslClient withDefaults(SaslClient config) {
        return new SaslClient(config.callbackHandlerClass(), config.mechanism(), config.jaasConfig == null ? null : JaasConfig.withDefaults(config.jaasConfig()), config.oauth == null ? null : OauthClientConfig.withDefaults(config.oauth()), ConfigUtil.defaultIfNullOrNonPositive(config.loginRetryBackoffMs(), 100L), ConfigUtil.defaultIfNullOrNonPositive(config.loginRetryBackoffMaxMs(), 10000L), ConfigUtil.defaultIfNullOrNonPositive(config.refreshWindowFactor(), 0.8), ConfigUtil.defaultIfNullOrNonPositive(config.refreshWindowJitter(), 0.05), ConfigUtil.defaultIfNullOrNonPositive(config.refreshMinPeriodSeconds(), (short)60), ConfigUtil.defaultIfNullOrNonPositive(config.refreshBufferSeconds(), (short)300));
    }
}

