/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface VersionInfo {
    public static final VersionInfo VERSION_INFO = VersionInfo.getVersionInfo();

    public String version();

    public String commitId();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static VersionInfo getVersionInfo() {
        try (InputStream resource = Info.class.getClassLoader().getResourceAsStream("META-INF/metadata.properties");){
            if (resource == null) return Info.UNKNOWN_VERSION_INFO;
            Properties properties = new Properties();
            properties.load(resource);
            String version = properties.getProperty("kroxylicious.version", "unknown");
            String commitId = properties.getProperty("git.commit.id", "unknown");
            Info info = new Info(version, commitId);
            return info;
        }
        catch (IOException e) {
            Logger logger = LoggerFactory.getLogger(Info.class);
            logger.warn("Failed to retrieve version information (ignored)", (Throwable)e);
        }
        return Info.UNKNOWN_VERSION_INFO;
    }

    public static final class Info
    implements VersionInfo {
        private static final String UNKNOWN = "unknown";
        private static final Info UNKNOWN_VERSION_INFO = new Info("unknown", "unknown");
        private final String version;
        private final String commitId;

        private Info(String version, String commitId) {
            this.version = Objects.requireNonNull(version);
            this.commitId = Objects.requireNonNull(commitId);
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public String commitId() {
            return this.commitId;
        }
    }
}

