/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.bootstrap;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kroxylicious.proxy.bootstrap.BootstrapSelectionStrategy;
import io.kroxylicious.proxy.service.HostPort;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RoundRobinBootstrapSelectionStrategy
implements BootstrapSelectionStrategy {
    @JsonIgnore
    private long counter = -1L;

    @Override
    public HostPort apply(List<HostPort> hostPorts) {
        int choice = (int)this.getNext(hostPorts.size());
        return hostPorts.get(choice);
    }

    @Override
    public String getStrategy() {
        return "round-robin";
    }

    private long getNext(long ceil) {
        ++this.counter;
        if (this.counter >= ceil) {
            this.counter = 0L;
        }
        return this.counter;
    }
}

