/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.bootstrap.BootstrapSelectionStrategy;
import io.kroxylicious.proxy.bootstrap.RoundRobinBootstrapSelectionStrategy;
import io.kroxylicious.proxy.config.tls.Tls;
import io.kroxylicious.proxy.service.HostPort;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record TargetCluster(@JsonProperty(value="bootstrapServers", required=true) String bootstrapServers, @JsonProperty(value="tls") Optional<Tls> tls, @JsonProperty(value="bootstrapServerSelection") @Nullable BootstrapSelectionStrategy selectionStrategy) {
    private static final BootstrapSelectionStrategy DEFAULT_SELECTION_STRATEGY = new RoundRobinBootstrapSelectionStrategy();

    @JsonCreator
    public TargetCluster {
        if (bootstrapServers == null) {
            throw new IllegalArgumentException("'bootstrapServers' is required in a target cluster.");
        }
    }

    public TargetCluster(String bootstrapServers, Optional<Tls> tls) {
        this(bootstrapServers, tls, DEFAULT_SELECTION_STRATEGY);
    }

    public List<HostPort> bootstrapServersList() {
        return Arrays.stream(this.bootstrapServers.split(",")).map(HostPort::parse).toList();
    }

    public HostPort bootstrapServer() {
        return this.resolveSelectionStrategy().apply(this.bootstrapServersList());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TargetCluster[");
        sb.append("bootstrapServers='").append(this.bootstrapServers).append('\'');
        sb.append(", tls=").append((String)this.tls.map(Tls::toString).orElse(null));
        sb.append(", bootstrapServerSelectionStrategy=").append(this.resolveSelectionStrategy().getClass().getSimpleName());
        sb.append(']');
        return sb.toString();
    }

    private BootstrapSelectionStrategy resolveSelectionStrategy() {
        return Objects.requireNonNullElse(this.selectionStrategy, DEFAULT_SELECTION_STRATEGY);
    }
}

