/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.filter;

import io.kroxylicious.proxy.filter.Filter;
import io.kroxylicious.proxy.filter.FilterAndInvoker;
import io.kroxylicious.proxy.filter.FilterInvoker;
import io.kroxylicious.proxy.filter.HandleNothingFilterInvoker;
import io.kroxylicious.proxy.filter.RequestFilter;
import io.kroxylicious.proxy.filter.RequestFilterInvoker;
import io.kroxylicious.proxy.filter.RequestResponseInvoker;
import io.kroxylicious.proxy.filter.ResponseFilter;
import io.kroxylicious.proxy.filter.ResponseFilterInvoker;
import io.kroxylicious.proxy.filter.SafeInvoker;
import io.kroxylicious.proxy.filter.SpecificFilterArrayInvoker;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class FilterInvokers {
    private FilterInvokers() {
    }

    static List<FilterAndInvoker> from(String filterName, Filter filter) {
        List<FilterAndInvoker> filterInvokers = FilterInvokers.invokersForFilter(filterName, filter);
        return FilterInvokers.wrapAllInSafeInvoker(filterInvokers).toList();
    }

    private static List<FilterAndInvoker> invokersForFilter(String filterName, Filter filter) {
        FilterCharacteristics characteristics = FilterCharacteristics.describeCharacteristics(filter);
        FilterInvokers.validateFilter(filterName, characteristics);
        Optional<FilterAndInvoker> genericInvoker = FilterInvokers.maybeGenericInvoker(filterName, filter, characteristics);
        Optional<FilterAndInvoker> specificInvoker = FilterInvokers.maybeSpecificInvoker(filterName, filter, characteristics);
        return Stream.concat(genericInvoker.stream(), specificInvoker.stream()).toList();
    }

    private static Optional<FilterAndInvoker> maybeSpecificInvoker(String filterName, Filter filter, FilterCharacteristics characteristics) {
        if (characteristics.isSpecificRequestFilter || characteristics.isSpecificResponseFilter) {
            return Optional.of(FilterInvokers.getFilterAndInvoker(filterName, filter, FilterInvokers.arrayInvoker(filter)));
        }
        return Optional.empty();
    }

    private static Optional<FilterAndInvoker> maybeGenericInvoker(String filterName, Filter filter, FilterCharacteristics characteristics) {
        if (characteristics.isAnyRequestFilter && characteristics.isAnyResponseFilter) {
            return Optional.of(FilterInvokers.getFilterAndInvoker(filterName, filter, new RequestResponseInvoker((RequestFilter)filter, (ResponseFilter)filter)));
        }
        if (characteristics.isAnyResponseFilter) {
            return Optional.of(FilterInvokers.getFilterAndInvoker(filterName, filter, new ResponseFilterInvoker((ResponseFilter)filter)));
        }
        if (characteristics.isAnyRequestFilter) {
            return Optional.of(FilterInvokers.getFilterAndInvoker(filterName, filter, new RequestFilterInvoker((RequestFilter)filter)));
        }
        return Optional.empty();
    }

    private static Stream<FilterAndInvoker> wrapAllInSafeInvoker(List<FilterAndInvoker> filterInvokers) {
        return filterInvokers.stream().map(filterAndInvoker -> FilterInvokers.getFilterAndInvoker(filterAndInvoker.filterName(), filterAndInvoker.filter(), new SafeInvoker(filterAndInvoker.invoker())));
    }

    private static void validateFilter(String filterName, FilterCharacteristics characteristics) {
        if (characteristics.isAnyRequestFilter && characteristics.isSpecificRequestFilter) {
            throw FilterInvokers.unsupportedFilterInstance(filterName, "Cannot mix specific request message filter interfaces and RequestFilter interfaces");
        }
        if (characteristics.isAnyResponseFilter && characteristics.isSpecificResponseFilter) {
            throw FilterInvokers.unsupportedFilterInstance(filterName, "Cannot mix specific response message filter interfaces and ResponseFilter interfaces");
        }
        if (!(characteristics.isAnyRequestFilter || characteristics.isAnyResponseFilter || characteristics.isSpecificRequestFilter || characteristics.isSpecificResponseFilter)) {
            throw FilterInvokers.unsupportedFilterInstance(filterName, "Filter must implement ResponseFilter, RequestFilter or any combination of specific message Filter interfaces");
        }
    }

    private static FilterAndInvoker getFilterAndInvoker(String filterName, Filter filter, FilterInvoker invoker) {
        return new FilterAndInvoker(filterName, filter, invoker);
    }

    public static FilterInvoker arrayInvoker(Filter filter) {
        return new SpecificFilterArrayInvoker(filter);
    }

    public static FilterInvoker handleNothingInvoker() {
        return HandleNothingFilterInvoker.INSTANCE;
    }

    private static IllegalArgumentException unsupportedFilterInstance(String filterName, String message) {
        return new IllegalArgumentException("Invoker could not be created for filter: " + filterName + ". " + message);
    }

    private record FilterCharacteristics(boolean isAnyRequestFilter, boolean isAnyResponseFilter, boolean isSpecificRequestFilter, boolean isSpecificResponseFilter) {
        static FilterCharacteristics describeCharacteristics(Filter filter) {
            boolean isAnyRequestFilter = filter instanceof RequestFilter;
            boolean isSpecificRequestFilter = SpecificFilterArrayInvoker.implementsAnySpecificRequestFilterInterface(filter);
            boolean isAnyResponseFilter = filter instanceof ResponseFilter;
            boolean isSpecificResponseFilter = SpecificFilterArrayInvoker.implementsAnySpecificResponseFilterInterface(filter);
            return new FilterCharacteristics(isAnyRequestFilter, isAnyResponseFilter, isSpecificRequestFilter, isSpecificResponseFilter);
        }
    }
}

