/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.frame;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.frame.ByteBufAccessor;
import io.kroxylicious.proxy.frame.Frame;
import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecodedFrame<H extends ApiMessage, B extends ApiMessage>
extends AbstractReferenceCounted
implements Frame {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecodedFrame.class);
    protected final short apiVersion;
    protected final int correlationId;
    protected final H header;
    protected final B body;
    private final List<ByteBuf> buffers;
    private int headerAndBodyEncodedLength;
    @Nullable
    private ObjectSerializationCache serializationCache;

    DecodedFrame(short apiVersion, int correlationId, H header, B body) {
        this.apiVersion = apiVersion;
        this.correlationId = correlationId;
        this.header = header;
        this.body = body;
        this.buffers = new ArrayList<ByteBuf>();
        this.headerAndBodyEncodedLength = -1;
    }

    @Override
    public int correlationId() {
        return this.correlationId;
    }

    @Override
    public short apiKeyId() {
        return this.body.apiKey();
    }

    public ApiKeys apiKey() {
        return ApiKeys.forId((int)this.apiKeyId());
    }

    @Override
    public short apiVersion() {
        return this.apiVersion;
    }

    @Override
    public boolean isDecoded() {
        return true;
    }

    protected abstract short headerVersion();

    public H header() {
        return this.header;
    }

    public B body() {
        return this.body;
    }

    @Override
    public final int estimateEncodedSize() {
        if (this.headerAndBodyEncodedLength != -1) {
            assert (this.serializationCache != null);
            return 4 + this.headerAndBodyEncodedLength;
        }
        short headerVersion = this.headerVersion();
        MessageSizeAccumulator sizer = new MessageSizeAccumulator();
        ObjectSerializationCache cache = new ObjectSerializationCache();
        this.header().addSize(sizer, cache, headerVersion);
        this.body().addSize(sizer, cache, this.apiVersion());
        this.headerAndBodyEncodedLength = sizer.totalSize();
        this.serializationCache = cache;
        return 4 + this.headerAndBodyEncodedLength;
    }

    @Override
    public final void encode(ByteBufAccessor out) {
        if (this.headerAndBodyEncodedLength < 0) {
            LOGGER.warn("Encoding estimation should happen before encoding, if possible");
        }
        int encodedSize = this.estimateEncodedSize();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Writing {} with 4 byte length ({}) plus bytes of header {}, and body {} to {}", new Object[]{this.getClass().getSimpleName(), encodedSize, this.header, this.body, out});
        }
        out.ensureWritable(encodedSize);
        int initialIndex = out.writerIndex();
        out.writeInt(this.headerAndBodyEncodedLength);
        ObjectSerializationCache cache = this.serializationCache;
        this.header.write((Writable)out, cache, this.headerVersion());
        this.body.write((Writable)out, cache, this.apiVersion());
        assert (out.writerIndex() - initialIndex == encodedSize);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.apiKey()) + "(" + this.apiVersion + ")v" + this.apiVersion + ", header=" + String.valueOf(this.header) + ", body=" + String.valueOf(this.body) + ")";
    }

    public void add(ByteBuf buffer) {
        this.buffers.add(buffer);
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    protected void deallocate() {
        this.buffers.forEach(ReferenceCounted::release);
    }

    public void transferBuffersTo(DecodedFrame<?, ?> frame) {
        frame.buffers.addAll(this.buffers);
        this.buffers.clear();
    }
}

