/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.frame;

import io.kroxylicious.proxy.frame.DecodedFrame;
import io.kroxylicious.proxy.frame.DecodedResponseFrame;
import io.kroxylicious.proxy.frame.RequestFrame;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;

public class DecodedRequestFrame<B extends ApiMessage>
extends DecodedFrame<RequestHeaderData, B>
implements RequestFrame {
    private final boolean decodeResponse;

    public DecodedRequestFrame(short apiVersion, int correlationId, boolean decodeResponse, RequestHeaderData header, B body) {
        super(apiVersion, correlationId, header, body);
        this.decodeResponse = decodeResponse;
    }

    @Override
    public short headerVersion() {
        return this.apiKey().messageType.requestHeaderVersion(this.apiVersion);
    }

    @Override
    public boolean decodeResponse() {
        return this.decodeResponse;
    }

    @Override
    public boolean hasResponse() {
        return !this.isZeroAcksProduceRequest();
    }

    private boolean isZeroAcksProduceRequest() {
        return this.apiKeyId() == ApiKeys.PRODUCE.id && ((ProduceRequestData)this.body).acks() == 0;
    }

    public DecodedResponseFrame<? extends ApiMessage> responseFrame(ResponseHeaderData header, ApiMessage message) {
        if (message.apiKey() != this.apiKeyId()) {
            throw new AssertionError((Object)("Attempt to create responseFrame with ApiMessage of type " + String.valueOf(ApiKeys.forId((int)message.apiKey())) + " but request is of type " + String.valueOf(this.apiKey())));
        }
        return this.createResponseFrame(header, message);
    }

    protected DecodedResponseFrame<? extends ApiMessage> createResponseFrame(ResponseHeaderData header, ApiMessage message) {
        return new DecodedResponseFrame<ApiMessage>(this.apiVersion(), this.correlationId(), header, message);
    }
}

