/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiVersionsServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiVersionsServiceImpl.class);
    private final Function<ApiKeys, Short> apiKeysShortFunction;

    public ApiVersionsServiceImpl() {
        this(Map.of());
    }

    public ApiVersionsServiceImpl(Map<ApiKeys, Short> overrideMap) {
        this((ApiKeys apiKeys) -> ApiVersionsServiceImpl.getMaxApiVersionFor(apiKeys, overrideMap));
        this.sanityCheckOverrides(overrideMap);
    }

    private void sanityCheckOverrides(Map<ApiKeys, Short> overrideMap) {
        List invalidEntries = overrideMap.entrySet().stream().flatMap(e -> this.validate((ApiKeys)e.getKey(), (Short)e.getValue())).toList();
        if (!invalidEntries.isEmpty()) {
            Collector<CharSequence, ?, String> validationMessages = Collectors.joining(",", "[", "]");
            throw new IllegalArgumentException("api versions override map contained invalid entries: " + invalidEntries.stream().collect(validationMessages));
        }
    }

    private Stream<String> validate(ApiKeys key, Short overrideLatestVersion) {
        short oldestVersion = key.oldestVersion();
        if (overrideLatestVersion < oldestVersion) {
            return Stream.of(key.name() + " specified max version " + overrideLatestVersion + " less than oldest supported version " + key.oldestVersion());
        }
        return Stream.of(new String[0]);
    }

    private ApiVersionsServiceImpl(Function<ApiKeys, Short> apiKeysShortFunction) {
        Objects.requireNonNull(apiKeysShortFunction);
        this.apiKeysShortFunction = apiKeysShortFunction;
    }

    private static short getMaxApiVersionFor(ApiKeys apiKey, Map<ApiKeys, Short> overrideMap) {
        short latest = apiKey.latestVersion(true);
        return Optional.ofNullable(overrideMap.get(apiKey)).map(m -> Integer.valueOf(Math.min(latest, m.intValue())).shortValue()).orElse(latest);
    }

    public void updateVersions(String channel, ApiVersionsResponseData apiVersionsResponse) {
        ApiVersionsServiceImpl.intersectApiVersions(channel, apiVersionsResponse, this.apiKeysShortFunction);
    }

    private static void intersectApiVersions(String channel, ApiVersionsResponseData resp, Function<ApiKeys, Short> apiKeysShortFunction) {
        HashSet<ApiVersionsResponseData.ApiVersion> unknownApis = new HashSet<ApiVersionsResponseData.ApiVersion>();
        for (ApiVersionsResponseData.ApiVersion key : resp.apiKeys()) {
            short apiId = key.apiKey();
            if (ApiKeys.hasId((int)apiId)) {
                ApiKeys apiKey = ApiKeys.forId((int)apiId);
                ApiVersionsServiceImpl.intersectApiVersion(channel, key, apiKey, apiKeysShortFunction);
                continue;
            }
            unknownApis.add(key);
        }
        resp.apiKeys().removeAll(unknownApis);
    }

    private static void intersectApiVersion(String channel, ApiVersionsResponseData.ApiVersion key, ApiKeys apiKey, Function<ApiKeys, Short> apiKeysShortFunction) {
        short mutualMin = (short)Math.max(key.minVersion(), apiKey.messageType.lowestSupportedVersion());
        if (mutualMin != key.minVersion()) {
            LOGGER.trace("{}: {} min version changed to {} (was: {})", new Object[]{channel, apiKey, mutualMin, key.maxVersion()});
            key.setMinVersion(mutualMin);
        } else {
            LOGGER.trace("{}: {} min version unchanged (is: {})", new Object[]{channel, apiKey, mutualMin});
        }
        short mutualMax = (short)Math.min(key.maxVersion(), apiKeysShortFunction.apply(apiKey).shortValue());
        if (mutualMax != key.maxVersion()) {
            LOGGER.trace("{}: {} max version changed to {} (was: {})", new Object[]{channel, apiKey, mutualMin, key.maxVersion()});
            key.setMaxVersion(mutualMax);
        } else {
            LOGGER.trace("{}: {} max version unchanged (is: {})", new Object[]{channel, apiKey, mutualMin});
        }
    }

    public short latestVersion(ApiKeys apiKey) {
        return this.apiKeysShortFunction.apply(apiKey);
    }
}

