/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import io.kroxylicious.proxy.config.MicrometerDefinition;
import io.kroxylicious.proxy.config.PluginFactoryRegistry;
import io.kroxylicious.proxy.internal.util.Metrics;
import io.kroxylicious.proxy.micrometer.MicrometerConfigurationHook;
import io.kroxylicious.proxy.micrometer.MicrometerConfigurationHookService;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeterRegistries
implements AutoCloseable {
    private final PrometheusMeterRegistry prometheusMeterRegistry;
    private static final Logger logger = LoggerFactory.getLogger(MeterRegistries.class);
    private final PluginFactoryRegistry pfr;
    private final List<MicrometerConfigurationHook> hooks;

    public MeterRegistries(PluginFactoryRegistry pfr, List<MicrometerDefinition> micrometerConfig) {
        this.pfr = pfr;
        this.hooks = this.registerHooks(micrometerConfig);
        this.prometheusMeterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        io.micrometer.core.instrument.Metrics.addRegistry((MeterRegistry)this.prometheusMeterRegistry);
    }

    private List<MicrometerConfigurationHook> registerHooks(List<MicrometerDefinition> micrometerConfig) {
        CompositeMeterRegistry globalRegistry = io.micrometer.core.instrument.Metrics.globalRegistry;
        MeterRegistries.preventDifferentTagNameRegistration(globalRegistry);
        List<MicrometerConfigurationHook> configurationHooks = micrometerConfig.stream().map(f -> this.pfr.pluginFactory(MicrometerConfigurationHookService.class).pluginInstance(f.type()).build(f.config())).toList();
        configurationHooks.forEach(micrometerConfigurationHook -> micrometerConfigurationHook.configure((MeterRegistry)globalRegistry));
        return configurationHooks;
    }

    static void preventDifferentTagNameRegistration(final CompositeMeterRegistry registry) {
        registry.config().meterFilter(new MeterFilter(){

            public MeterFilterReply accept(Meter.Id id) {
                boolean allTagsSame = registry.find(id.getName()).meters().stream().allMatch(meter -> MeterRegistries.tagNames(meter.getId()).equals(MeterRegistries.tagNames(id)));
                if (!allTagsSame) {
                    logger.error("Attempted to register a meter with id {} which is already registered but with a different set of tag names", (Object)id);
                    throw new IllegalArgumentException("tags for id " + String.valueOf(id) + " differ from existing meters registered");
                }
                return MeterFilterReply.ACCEPT;
            }
        });
    }

    private static Object tagNames(Meter.Id id1) {
        return id1.getTags().stream().map(Tag::getKey).collect(Collectors.toSet());
    }

    public Optional<PrometheusMeterRegistry> maybePrometheusMeterRegistry() {
        return Optional.ofNullable(this.prometheusMeterRegistry);
    }

    @Override
    public void close() {
        this.hooks.forEach(MicrometerConfigurationHook::close);
        List copy = List.copyOf(this.prometheusMeterRegistry.getMeters());
        copy.forEach(arg_0 -> ((CompositeMeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry).remove(arg_0));
        io.micrometer.core.instrument.Metrics.removeRegistry((MeterRegistry)this.prometheusMeterRegistry);
        Metrics.clear();
    }
}

