/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import io.kroxylicious.proxy.internal.net.EndpointGateway;
import io.kroxylicious.proxy.model.VirtualClusterModel;
import io.kroxylicious.proxy.service.HostPort;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;

public class PortConflictDetector {
    private static final String ANY_STRING = "<any>";

    public void validate(Collection<VirtualClusterModel> virtualClusterModelMap, Optional<HostPort> otherExclusivePort) {
        List<CandidateBinding> candidateBindings = PortConflictDetector.candidateBindings(virtualClusterModelMap);
        PortConflictDetector.validateCandidatesDoNotConflictWithOtherExclusivePort(candidateBindings, otherExclusivePort);
        this.validateSharedPortsRequireServerNameIndication(candidateBindings);
        PortConflictDetector.validateCandidatesDoNotConflictWithEachOther(candidateBindings);
    }

    private void validateSharedPortsRequireServerNameIndication(List<CandidateBinding> candidateBindings) {
        candidateBindings.stream().filter(binding -> binding.scope == BindingScope.SHARED).forEach(binding -> {
            if (!binding.gateway.requiresServerNameIndication()) {
                throw new IllegalStateException(String.valueOf(binding) + " is misconfigured, shared port bindings must use server name indication, or connections cannot be routed correctly");
            }
        });
    }

    private static void validateCandidatesDoNotConflictWithOtherExclusivePort(List<CandidateBinding> candidateBindings, Optional<HostPort> otherExclusivePort) {
        otherExclusivePort.ifPresent(hostPort -> candidateBindings.forEach(c -> c.validateNonConflicting((HostPort)hostPort)));
    }

    private static void validateCandidatesDoNotConflictWithEachOther(List<CandidateBinding> candidateBindings) {
        for (int i = 0; i < candidateBindings.size(); ++i) {
            for (int j = i + 1; j < candidateBindings.size(); ++j) {
                candidateBindings.get(i).validateNonConflicting(candidateBindings.get(j));
            }
        }
    }

    private static List<CandidateBinding> candidateBindings(Collection<VirtualClusterModel> virtualClusterModelMap) {
        return virtualClusterModelMap.stream().sorted(Comparator.comparing(VirtualClusterModel::getClusterName)).flatMap(m -> m.gateways().values().stream().sorted(Comparator.comparing(EndpointGateway::name))).flatMap(gateway -> {
            Stream<CandidateBinding> exclusiveBindings = gateway.getExclusivePorts().stream().sorted().map(exclusivePort -> new CandidateBinding((EndpointGateway)gateway, (int)exclusivePort, new BindAddress(gateway.getBindAddress()), BindingScope.EXCLUSIVE));
            Stream<CandidateBinding> sharedBindings = gateway.getSharedPorts().stream().sorted().map(sharedPort -> new CandidateBinding((EndpointGateway)gateway, (int)sharedPort, new BindAddress(gateway.getBindAddress()), BindingScope.SHARED));
            return Stream.concat(exclusiveBindings, sharedBindings);
        }).toList();
    }

    private record CandidateBinding(EndpointGateway gateway, int port, BindAddress bindAddress, BindingScope scope) {
        void validateNonConflicting(CandidateBinding other) {
            if (this.port == other.port && this.bindAddress.overlaps(other.bindAddress)) {
                if (this.scope == BindingScope.EXCLUSIVE || other.scope == BindingScope.EXCLUSIVE) {
                    throw this.conflictException(other, "exclusive port collision");
                }
                if (!this.bindAddress.equals(other.bindAddress)) {
                    throw this.conflictException(other, "shared port cannot bind to different hosts");
                }
                if (this.gateway.isUseTls() != other.gateway.isUseTls()) {
                    throw this.conflictException(other, "shared port cannot be both TLS and non-TLS");
                }
            }
        }

        private IllegalStateException conflictException(CandidateBinding other, String reason) {
            return new IllegalStateException(String.valueOf(this) + " conflicts with " + String.valueOf(other) + ": " + reason);
        }

        void validateNonConflicting(HostPort otherExclusivePort) {
            boolean isAnyHost = otherExclusivePort.host().equals("0.0.0.0");
            BindAddress otherBindAddress = new BindAddress(isAnyHost ? Optional.empty() : Optional.of(otherExclusivePort.host()));
            if (this.port == otherExclusivePort.port() && this.bindAddress.overlaps(otherBindAddress)) {
                throw new IllegalStateException(String.valueOf(this) + " conflicts with another (non-cluster) exclusive port " + String.valueOf(otherExclusivePort));
            }
        }

        @Override
        public String toString() {
            return this.scope.name().toLowerCase(Locale.ENGLISH) + " " + (this.gateway.isUseTls() ? "TLS" : "TCP") + " bind of " + String.valueOf(this.bindAddress) + ":" + this.port + " for gateway '" + this.gateway.name() + "' of virtual cluster '" + this.gateway.virtualCluster().getClusterName() + "'";
        }
    }

    private record BindAddress(Optional<String> address) {
        boolean overlaps(BindAddress other) {
            return this.isAnyHost() || other.isAnyHost() || this.address.equals(other.address);
        }

        boolean isAnyHost() {
            return this.address.isEmpty();
        }

        @Override
        public String toString() {
            return this.address.orElse(PortConflictDetector.ANY_STRING);
        }
    }

    private static enum BindingScope {
        SHARED,
        EXCLUSIVE;

    }
}

