/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.admin;

import io.kroxylicious.proxy.config.admin.EndpointsConfiguration;
import io.kroxylicious.proxy.config.admin.ManagementConfiguration;
import io.kroxylicious.proxy.internal.MeterRegistries;
import io.kroxylicious.proxy.internal.admin.PrometheusMetricsEndpoint;
import io.kroxylicious.proxy.internal.admin.RoutingHttpServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import java.util.Objects;
import java.util.Optional;

public class ManagementInitializer
extends ChannelInitializer<SocketChannel> {
    private static final String LIVEZ = "/livez";
    private final MeterRegistries registries;
    private final ManagementConfiguration managementConfiguration;

    public ManagementInitializer(MeterRegistries registries, ManagementConfiguration managementConfiguration) {
        Objects.requireNonNull(registries);
        Objects.requireNonNull(managementConfiguration);
        this.registries = registries;
        this.managementConfiguration = managementConfiguration;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new HttpServerCodec()});
        p.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
        RoutingHttpServer.RoutingHttpServerBuilder builder = RoutingHttpServer.builder();
        builder.withRoute(LIVEZ, httpRequest -> RoutingHttpServer.responseWithStatus(httpRequest, HttpResponseStatus.OK));
        Optional.ofNullable(this.managementConfiguration.endpoints()).map(EndpointsConfiguration::maybePrometheus).ifPresent(prometheusMetricsConfig -> builder.withRoute("/metrics", new PrometheusMetricsEndpoint(this.registries)));
        p.addLast(new ChannelHandler[]{builder.build()});
    }
}

