/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.codec;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.filter.Filter;
import io.kroxylicious.proxy.frame.DecodedResponseFrame;
import io.kroxylicious.proxy.frame.Frame;
import io.kroxylicious.proxy.frame.OpaqueFrame;
import io.kroxylicious.proxy.frame.OpaqueResponseFrame;
import io.kroxylicious.proxy.internal.InternalResponseFrame;
import io.kroxylicious.proxy.internal.codec.BodyDecoder;
import io.kroxylicious.proxy.internal.codec.ByteBufAccessorImpl;
import io.kroxylicious.proxy.internal.codec.CorrelationManager;
import io.kroxylicious.proxy.internal.codec.KafkaMessageDecoder;
import io.kroxylicious.proxy.internal.codec.KafkaMessageListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Readable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaResponseDecoder
extends KafkaMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaResponseDecoder.class);
    public static final short EMERGENCY_API_VERSION = 0;
    private final CorrelationManager correlationManager;

    public KafkaResponseDecoder(CorrelationManager correlationManager, int socketRequestMaxSizeBytes, @Nullable KafkaMessageListener listener) {
        super(socketRequestMaxSizeBytes, listener);
        this.correlationManager = correlationManager;
    }

    @Override
    protected Logger log() {
        return LOGGER;
    }

    @Override
    protected Frame decodeHeaderAndBody(ChannelHandlerContext ctx, ByteBuf in, int length) {
        Frame frame;
        int wi = in.writerIndex();
        int ri = in.readerIndex();
        int upstreamCorrelationId = in.readInt();
        in.readerIndex(ri);
        CorrelationManager.Correlation correlation = this.correlationManager.getBrokerCorrelation(upstreamCorrelationId);
        if (correlation == null) {
            throw new AssertionError((Object)("Missing correlation id " + upstreamCorrelationId));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Recovered correlation {} for upstream correlation id {}", new Object[]{ctx, correlation, upstreamCorrelationId});
        }
        int correlationId = correlation.downstreamCorrelationId();
        in.writerIndex(ri);
        in.writeInt(correlationId);
        in.writerIndex(wi);
        if (correlation.decodeResponse()) {
            ApiKeys apiKey = ApiKeys.forId((int)correlation.apiKey());
            short apiVersion = correlation.apiVersion();
            ByteBufAccessorImpl accessor = new ByteBufAccessorImpl(in);
            short headerVersion = apiKey.responseHeaderVersion(apiVersion);
            this.log().trace("{}: Header version: {}", (Object)ctx, (Object)headerVersion);
            ResponseHeaderData header = this.readHeader(headerVersion, accessor);
            this.log().trace("{}: Header: {}", (Object)ctx, (Object)header);
            ApiMessageVersion body = KafkaResponseDecoder.decodeBody(apiKey, apiVersion, accessor);
            this.log().trace("{}: Body: {}", (Object)ctx, (Object)body);
            Filter recipient = correlation.recipient();
            frame = recipient == null ? new DecodedResponseFrame<ApiMessage>(body.apiVersion(), correlationId, header, body.apiMessage()) : new InternalResponseFrame<ApiMessage>(recipient, body.apiVersion(), correlationId, header, body.apiMessage(), correlation.promise());
        } else {
            frame = this.opaqueFrame(correlation.apiKey(), correlation.apiVersion(), in, correlationId, length);
        }
        this.log().trace("{}: Frame: {}", (Object)ctx, (Object)frame);
        return frame;
    }

    private static ApiMessageVersion decodeBody(ApiKeys apiKey, short apiVersion, ByteBufAccessorImpl accessor) {
        int prev = accessor.readerIndex();
        try {
            return new ApiMessageVersion(BodyDecoder.decodeResponse(apiKey, apiVersion, accessor), apiVersion);
        }
        catch (RuntimeException e) {
            accessor.readerIndex(prev);
            if (ApiKeys.API_VERSIONS.equals((Object)apiKey) && apiVersion != 0) {
                return new ApiMessageVersion(BodyDecoder.decodeResponse(apiKey, (short)0, accessor), 0);
            }
            throw e;
        }
    }

    private OpaqueFrame opaqueFrame(short apiKeyId, short apiVersion, ByteBuf in, int correlationId, int length) {
        return new OpaqueResponseFrame(apiKeyId, apiVersion, in.readSlice(length).retain(), correlationId, length);
    }

    private ResponseHeaderData readHeader(short headerVersion, Readable accessor) {
        return new ResponseHeaderData(accessor, headerVersion);
    }

    record ApiMessageVersion(ApiMessage apiMessage, short apiVersion) {
    }
}

