/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.config;

import io.kroxylicious.proxy.config.Configuration;
import io.kroxylicious.proxy.internal.config.Feature;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Features {
    private static final Features DEFAULT_FEATURES = new Features(Map.of());
    private final Map<Feature, Boolean> featureToEnabled;

    private Features(Map<Feature, Boolean> featureToEnabled) {
        this.featureToEnabled = featureToEnabled;
    }

    public List<String> supports(Configuration configuration) {
        return Arrays.stream(Feature.values()).flatMap(feature -> feature.supports(configuration, this.isEnabled((Feature)((Object)feature)))).toList();
    }

    public boolean isEnabled(Feature feature) {
        return this.featureToEnabled.getOrDefault((Object)feature, feature.enabledByDefault());
    }

    public static Features defaultFeatures() {
        return DEFAULT_FEATURES;
    }

    public List<String> warnings() {
        return Arrays.stream(Feature.values()).flatMap(feature -> feature.maybeWarning(this.isEnabled((Feature)((Object)feature))).stream()).toList();
    }

    public static FeaturesBuilder builder() {
        return new FeaturesBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Features features1 = (Features)o;
        return Objects.equals(this.featureToEnabled, features1.featureToEnabled);
    }

    public int hashCode() {
        return Objects.hashCode(this.featureToEnabled);
    }

    public String toString() {
        return Arrays.stream(Feature.values()).map(f -> f.name() + ": " + (this.isEnabled((Feature)((Object)f)) ? "enabled" : "disabled")).collect(Collectors.joining(",", "[", "]"));
    }

    public static class FeaturesBuilder {
        private final Map<Feature, Boolean> features = new EnumMap<Feature, Boolean>(Feature.class);

        public FeaturesBuilder enable(Feature feature) {
            this.features.put(feature, true);
            return this;
        }

        public Features build() {
            if (this.features.isEmpty()) {
                return Features.defaultFeatures();
            }
            return new Features(Collections.unmodifiableMap(this.features));
        }
    }
}

