/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.filter;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.filter.RequestFilterResult;
import io.kroxylicious.proxy.filter.RequestFilterResultBuilder;
import io.kroxylicious.proxy.filter.filterresultbuilder.CloseOrTerminalStage;
import io.kroxylicious.proxy.internal.KafkaProxyExceptionMapper;
import io.kroxylicious.proxy.internal.filter.FilterResultBuilderImpl;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.AbstractResponse;

public class RequestFilterResultBuilderImpl
extends FilterResultBuilderImpl<RequestHeaderData, RequestFilterResult>
implements RequestFilterResultBuilder {
    private static final String REQUEST_DATA_NAME_SUFFIX = "RequestData";
    private static final String RESPONSE_DATA_NAME_SUFFIX = "ResponseData";
    @Nullable
    private ResponseHeaderData shortCircuitHeader;
    @Nullable
    private ApiMessage shortCircuitResponse;

    @Override
    protected void validateForward(RequestHeaderData header, ApiMessage message) {
        super.validateForward(header, message);
        if (!message.getClass().getSimpleName().endsWith(REQUEST_DATA_NAME_SUFFIX)) {
            throw new IllegalArgumentException("class name " + message.getClass().getName() + " does not have expected suffix RequestData");
        }
    }

    public CloseOrTerminalStage<RequestFilterResult> shortCircuitResponse(@Nullable ResponseHeaderData header, ApiMessage message) {
        this.validateShortCircuitResponse(message);
        this.shortCircuitHeader = header;
        this.shortCircuitResponse = message;
        return this;
    }

    public CloseOrTerminalStage<RequestFilterResult> shortCircuitResponse(ApiMessage message) {
        this.validateShortCircuitResponse(message);
        this.shortCircuitResponse = message;
        return this;
    }

    public CloseOrTerminalStage<RequestFilterResult> errorResponse(RequestHeaderData header, ApiMessage request, ApiException apiException) throws IllegalArgumentException {
        AbstractResponse errorResponseMessage = KafkaProxyExceptionMapper.errorResponseForMessage(header, request, apiException);
        this.validateShortCircuitResponse(errorResponseMessage.data());
        ResponseHeaderData responseHeaders = new ResponseHeaderData();
        responseHeaders.setCorrelationId(header.correlationId());
        this.shortCircuitHeader = responseHeaders;
        this.shortCircuitResponse = errorResponseMessage.data();
        return this;
    }

    private void validateShortCircuitResponse(ApiMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("message may not be null");
        }
        if (!message.getClass().getSimpleName().endsWith(RESPONSE_DATA_NAME_SUFFIX)) {
            throw new IllegalArgumentException("class name " + message.getClass().getName() + " does not have expected suffix ResponseData");
        }
    }

    public RequestFilterResult build() {
        return new RequestFilterResult(){

            public boolean shortCircuitResponse() {
                return RequestFilterResultBuilderImpl.this.shortCircuitResponse != null;
            }

            @Nullable
            public ApiMessage header() {
                return RequestFilterResultBuilderImpl.this.shortCircuitResponse == null ? RequestFilterResultBuilderImpl.this.header() : RequestFilterResultBuilderImpl.this.shortCircuitHeader;
            }

            @Nullable
            public ApiMessage message() {
                return RequestFilterResultBuilderImpl.this.shortCircuitResponse == null ? RequestFilterResultBuilderImpl.this.message() : RequestFilterResultBuilderImpl.this.shortCircuitResponse;
            }

            public boolean closeConnection() {
                return RequestFilterResultBuilderImpl.this.closeConnection();
            }

            public boolean drop() {
                return RequestFilterResultBuilderImpl.this.isDrop();
            }
        };
    }
}

