/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.net;

import io.kroxylicious.proxy.internal.net.NetworkBindingOperation;
import io.kroxylicious.proxy.internal.net.NetworkBindingOperationProcessor;
import io.netty.bootstrap.ServerBootstrap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNetworkBindingOperationProcessor
implements NetworkBindingOperationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultNetworkBindingOperationProcessor.class);
    private final BlockingQueue<NetworkBindingOperation<?>> queue = new LinkedBlockingQueue();
    private final AtomicBoolean running = new AtomicBoolean();
    private final ExecutorService networkBindingExecutor = Executors.newFixedThreadPool(2, r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        return t;
    });
    private static final NetworkBindingOperation<Void> POISON_PILL = new NetworkBindingOperation<Void>(false){
        CompletableFuture<Void> swallowed = new CompletableFuture();

        @Override
        public int port() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<Void> getFuture() {
            return this.swallowed;
        }

        @Override
        public void performBindingOperation(ServerBootstrap serverBootstrap, ExecutorService executorService) {
            throw new UnsupportedOperationException();
        }
    };

    @Override
    public void enqueueNetworkBindingEvent(NetworkBindingOperation<?> o) {
        this.queue.add(o);
    }

    @Override
    public void start(ServerBootstrap plainServerBootstrap, ServerBootstrap tlsServerBootstrap) {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        Future<?> unused = this.networkBindingExecutor.submit(() -> {
            try {
                do {
                    NetworkBindingOperation<?> networkBindingOperation;
                    if ((networkBindingOperation = this.queue.take()) == POISON_PILL) {
                        return;
                    }
                    ServerBootstrap bootstrap = networkBindingOperation.tls() ? tlsServerBootstrap : plainServerBootstrap;
                    try {
                        networkBindingOperation.performBindingOperation(bootstrap, this.networkBindingExecutor);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected error performing the binding operation", (Throwable)e);
                    }
                } while (!Thread.interrupted());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            finally {
                POISON_PILL.getFuture().complete(null);
                this.networkBindingExecutor.shutdown();
                LOGGER.debug("Network event processor shutdown");
            }
        });
    }

    @Override
    public void close() {
        if (!this.running.compareAndSet(true, false)) {
            this.networkBindingExecutor.shutdown();
            return;
        }
        this.enqueueNetworkBindingEvent(POISON_PILL);
        boolean shutdown = false;
        try {
            POISON_PILL.getFuture().get(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(e);
        }
        finally {
            if (!shutdown) {
                this.networkBindingExecutor.shutdownNow();
            }
        }
    }
}

