/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.net;

import io.kroxylicious.proxy.internal.net.EndpointResolutionException;
import io.netty.channel.Channel;
import io.netty.channel.socket.ServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;

public record Endpoint(Optional<String> bindingAddress, int port, boolean tls) {
    public Endpoint {
        Objects.requireNonNull(bindingAddress);
    }

    public static Endpoint createEndpoint(Channel ch, boolean tls) {
        try {
            Channel channel = ch.parent();
            if (channel instanceof ServerSocketChannel) {
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)channel;
                InetSocketAddress serverSocketAddress = serverSocketChannel.localAddress();
                Optional<String> bindingAddress = serverSocketAddress.getAddress().isAnyLocalAddress() ? Optional.empty() : Optional.of(serverSocketAddress.getAddress().getHostAddress());
                return new Endpoint(bindingAddress, serverSocketAddress.getPort(), tls);
            }
            throw new UnsupportedOperationException("Channel parent is either not ServerSocketChannel or the channel/channel parent is null");
        }
        catch (Exception e) {
            throw new EndpointResolutionException("Failed to create endpoint for the channel: " + e.getMessage(), e);
        }
    }

    public static Endpoint createEndpoint(Optional<String> bindingAddress, int port, boolean tls) {
        return new Endpoint(bindingAddress, port, tls);
    }

    public static Endpoint createEndpoint(int port, boolean tls) {
        return Endpoint.createEndpoint(Optional.empty(), port, tls);
    }
}

