/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.VersionInfo;
import io.kroxylicious.proxy.internal.util.ActivationToken;
import io.kroxylicious.proxy.internal.util.VirtualClusterNode;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Metrics {
    public static final String VIRTUAL_CLUSTER_LABEL = "virtual_cluster";
    public static final String NODE_ID_LABEL = "node_id";
    public static final String API_KEY_LABEL = "api_key";
    public static final String API_VERSION_LABEL = "api_version";
    public static final String DECODED_LABEL = "decoded";
    public static final String DEPRECATED_API_KEY_TAG = "ApiKey";
    public static final String DEPRECATED_API_VERSION_TAG = "ApiVersion";
    public static final String DEPRECATED_FLOWING_TAG = "flowing";
    public static final String DEPRECATED_VIRTUAL_CLUSTER_TAG = "virtualCluster";
    public static final String DOWNSTREAM_FLOWING_VALUE = "downstream";
    public static final String UPSTREAM_FLOWING_VALUE = "upstream";
    private static final String CLIENT_TO_PROXY_REQUEST_BASE_METER_NAME = "kroxylicious_client_to_proxy_request";
    private static final String PROXY_TO_SERVER_REQUEST_BASE_METER_NAME = "kroxylicious_proxy_to_server_request";
    private static final String SERVER_TO_PROXY_RESPONSE_BASE_METER_NAME = "kroxylicious_server_to_proxy_response";
    private static final String PROXY_TO_CLIENT_RESPONSE_BASE_METER_NAME = "kroxylicious_proxy_to_client_response";
    private static final String CLIENT_TO_PROXY_ERROR_BASE_METER_NAME = "kroxylicious_client_to_proxy_errors";
    private static final String PROXY_TO_SERVER_ERROR_BASE_METER_NAME = "kroxylicious_proxy_to_server_errors";
    private static final String CLIENT_TO_PROXY_CONNECTION_BASE_METER_NAME = "kroxylicious_client_to_proxy_connections";
    private static final String PROXY_TO_SERVER_CONNECTION_BASE_METER_NAME = "kroxylicious_proxy_to_server_connections";
    private static final String KROXYLICIOUS_SERVER_TO_PROXY_READS_PAUSED_NAME = "kroxylicious_server_to_proxy_reads_paused";
    private static final String KROXYLICIOUS_CLIENT_TO_PROXY_READS_PAUSED_NAME = "kroxylicious_client_to_proxy_reads_paused";
    private static final String CLIENT_TO_PROXY_ACTIVE_CONNECTION_BASE_METER_NAME = "kroxylicious_client_to_proxy_active_connections";
    private static final String PROXY_TO_SERVER_ACTIVE_CONNECTION_BASE_METER_NAME = "kroxylicious_proxy_to_server_active_connections";
    private static final String SIZE_SUFFIX = "_size";
    private static final String INFO_METRIC_NAME = "kroxylicious_build.info";
    private static final ConcurrentHashMap<VirtualClusterNode, AtomicInteger> CLIENT_TO_PROXY_CONNECTION_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<VirtualClusterNode, AtomicInteger> PROXY_TO_SERVER_CONNECTION_CACHE = new ConcurrentHashMap();
    @Deprecated(since="0.13.0", forRemoval=true)
    public static final String KROXYLICIOUS_INBOUND_DOWNSTREAM_MESSAGES = "kroxylicious_inbound_downstream_messages";
    @Deprecated(since="0.13.0", forRemoval=true)
    public static final String KROXYLICIOUS_INBOUND_DOWNSTREAM_DECODED_MESSAGES = "kroxylicious_inbound_downstream_decoded_messages";
    private static final String KROXYLICIOUS_DOWNSTREAM = "kroxylicious_downstream_";
    private static final String KROXYLICIOUS_UPSTREAM = "kroxylicious_upstream_";
    @Deprecated(since="0.13.0", forRemoval=true)
    public static final String KROXYLICIOUS_DOWNSTREAM_CONNECTIONS = "kroxylicious_downstream_connections";
    @Deprecated(since="0.13.0", forRemoval=true)
    public static final String KROXYLICIOUS_DOWNSTREAM_ERRORS = "kroxylicious_downstream_errors";
    @Deprecated(since="0.13.0", forRemoval=true)
    public static final String KROXYLICIOUS_UPSTREAM_CONNECTIONS = "kroxylicious_upstream_connections";
    @Deprecated(since="0.13.0", forRemoval=true)
    public static final String KROXYLICIOUS_UPSTREAM_CONNECTION_ATTEMPTS = "kroxylicious_upstream_connection_attempts";
    @Deprecated(since="0.13.0", forRemoval=true)
    public static final String KROXYLICIOUS_UPSTREAM_CONNECTION_FAILURES = "kroxylicious_upstream_connection_failures";
    @Deprecated(since="0.13.0", forRemoval=true)
    public static final String KROXYLICIOUS_UPSTREAM_ERRORS = "kroxylicious_upstream_errors";
    @Deprecated(since="0.13.0", forRemoval=true)
    public static final String KROXYLICIOUS_PAYLOAD_SIZE_BYTES = "kroxylicious_payload_size_bytes";

    private Metrics() {
    }

    public static Meter.MeterProvider<Counter> clientToProxyMessageCounterProvider(String clusterName, Integer nodeId) {
        return Metrics.buildCounterMeterProvider(CLIENT_TO_PROXY_REQUEST_BASE_METER_NAME, "Count of the number of requests received by the proxy from the client.", clusterName, nodeId);
    }

    public static Meter.MeterProvider<DistributionSummary> proxyToClientMessageSizeDistributionProvider(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildDistributionSummaryMeterProvider(PROXY_TO_CLIENT_RESPONSE_BASE_METER_NAME, "Distribution of the size, in bytes, of responses sent from the proxy to the client.", clusterName, "bytes", nodeId);
    }

    public static Meter.MeterProvider<Counter> proxyToClientMessageCounterProvider(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildCounterMeterProvider(PROXY_TO_CLIENT_RESPONSE_BASE_METER_NAME, "Count of the number of responses sent from the proxy to the client.", clusterName, nodeId);
    }

    public static Meter.MeterProvider<DistributionSummary> clientToProxyMessageSizeDistributionProvider(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildDistributionSummaryMeterProvider(CLIENT_TO_PROXY_REQUEST_BASE_METER_NAME, "Distribution of the size, in bytes, of the requests received from the client.", clusterName, "bytes", nodeId);
    }

    public static Meter.MeterProvider<DistributionSummary> serverToProxyMessageSizeDistributionProvider(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildDistributionSummaryMeterProvider(SERVER_TO_PROXY_RESPONSE_BASE_METER_NAME, "Distribution of the size, in bytes, of responses received from the server.", clusterName, "bytes", nodeId);
    }

    public static Meter.MeterProvider<DistributionSummary> proxyToServerMessageSizeDistributionProvider(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildDistributionSummaryMeterProvider(PROXY_TO_SERVER_REQUEST_BASE_METER_NAME, "Distribution of size, in bytes, of requests sent to the server", clusterName, "bytes", nodeId);
    }

    public static Meter.MeterProvider<Counter> serverToProxyMessageCounterProvider(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildCounterMeterProvider(SERVER_TO_PROXY_RESPONSE_BASE_METER_NAME, "Count of the number of responses received by the proxy from the server.", clusterName, nodeId);
    }

    public static Meter.MeterProvider<Counter> proxyToServerMessageCounterProvider(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildCounterMeterProvider(PROXY_TO_SERVER_REQUEST_BASE_METER_NAME, "Count of the number of requests sent to the server.", clusterName, nodeId);
    }

    public static Meter.MeterProvider<Counter> clientToProxyConnectionCounter(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildCounterMeterProvider(CLIENT_TO_PROXY_CONNECTION_BASE_METER_NAME, "Count of the number of times a connection is accepted from the clients.", clusterName, nodeId);
    }

    public static Meter.MeterProvider<Counter> clientToProxyErrorCounter(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildCounterMeterProvider(CLIENT_TO_PROXY_ERROR_BASE_METER_NAME, "Count of the number of times a connection is closed due to any downstream error.", clusterName, nodeId);
    }

    public static Meter.MeterProvider<Counter> proxyToServerConnectionCounter(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildCounterMeterProvider(PROXY_TO_SERVER_CONNECTION_BASE_METER_NAME, "Count of the number of times a connection is made to the server from the proxy.", clusterName, nodeId);
    }

    public static Meter.MeterProvider<Counter> proxyToServerErrorCounter(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildCounterMeterProvider(PROXY_TO_SERVER_ERROR_BASE_METER_NAME, "Count of the number of times a connection is closed due to any upstream error.", clusterName, nodeId);
    }

    public static Meter.MeterProvider<Timer> serverToProxyBackpressureTimer(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildTimerMeterProvider(KROXYLICIOUS_SERVER_TO_PROXY_READS_PAUSED_NAME, "Timer showing how long the proxy has paused reading from a upstream connection because the downstream connection is unwriteable.", clusterName, nodeId);
    }

    public static Meter.MeterProvider<Timer> clientToProxyBackpressureTimer(String clusterName, @Nullable Integer nodeId) {
        return Metrics.buildTimerMeterProvider(KROXYLICIOUS_CLIENT_TO_PROXY_READS_PAUSED_NAME, "Timer showing how long the proxy has paused reading from a downstream connection because the upstream connection is unwriteable.", clusterName, nodeId);
    }

    public static ActivationToken clientToProxyConnectionToken(VirtualClusterNode node) {
        AtomicInteger currentCounter = Metrics.clientToProxyConnectionCounter(node);
        return new ActivationToken(currentCounter);
    }

    public static AtomicInteger clientToProxyConnectionCounter(VirtualClusterNode node) {
        return CLIENT_TO_PROXY_CONNECTION_CACHE.computeIfAbsent(node, n -> {
            AtomicInteger activeCount = new AtomicInteger();
            Gauge.builder((String)CLIENT_TO_PROXY_ACTIVE_CONNECTION_BASE_METER_NAME, (Object)activeCount, AtomicInteger::get).strongReference(true).description("Number of currently active connections from the client to the proxy.").tag(VIRTUAL_CLUSTER_LABEL, node.clusterName()).tag(NODE_ID_LABEL, Metrics.nodeIdToLabelValue(node.nodeId())).register((MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry);
            return activeCount;
        });
    }

    public static ActivationToken proxyToServerConnectionToken(VirtualClusterNode node) {
        AtomicInteger currentCounter = Metrics.proxyToServerConnectionCounter(node);
        return new ActivationToken(currentCounter);
    }

    public static AtomicInteger proxyToServerConnectionCounter(VirtualClusterNode node) {
        return PROXY_TO_SERVER_CONNECTION_CACHE.computeIfAbsent(node, n -> {
            AtomicInteger activeCount = new AtomicInteger();
            Gauge.builder((String)PROXY_TO_SERVER_ACTIVE_CONNECTION_BASE_METER_NAME, (Object)activeCount, AtomicInteger::get).strongReference(true).description("Number of currently active connections from the proxy to the server.").tag(VIRTUAL_CLUSTER_LABEL, node.clusterName()).tag(NODE_ID_LABEL, Metrics.nodeIdToLabelValue(node.nodeId())).register((MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry);
            return activeCount;
        });
    }

    public static Counter taggedCounter(String counterName, List<Tag> tags) {
        return io.micrometer.core.instrument.Metrics.counter((String)counterName, tags);
    }

    public static List<Tag> tags(String name, String value) {
        return List.of(Tag.of((String)name, (String)Metrics.required(value)));
    }

    public static List<Tag> tags(String name1, String value1, String name2, String value2) {
        return List.of(Tag.of((String)name1, (String)Metrics.required(value1)), Tag.of((String)name2, (String)Metrics.required(value2)));
    }

    public static List<Tag> tags(String ... tagsAndValues) {
        if (tagsAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("tag name supplied without a value");
        }
        ArrayList<Tag> tagsList = new ArrayList<Tag>();
        for (int i = 0; i < tagsAndValues.length; i += 2) {
            tagsList.add(Tag.of((String)tagsAndValues[i], (String)Metrics.required(tagsAndValues[i + 1])));
        }
        return List.copyOf(tagsList);
    }

    private static String required(String value) {
        if (Objects.isNull(value) || value.trim().isEmpty()) {
            throw new IllegalArgumentException("tag value supplied without a value");
        }
        return value;
    }

    private static String nodeIdToLabelValue(@Nullable Integer nodeId) {
        return Optional.ofNullable(nodeId).map(Object::toString).orElse("bootstrap");
    }

    private static Meter.MeterProvider<Counter> buildCounterMeterProvider(String meterName, String description, String clusterName, @Nullable Integer nodeId) {
        return Counter.builder((String)meterName).description(description).tag(VIRTUAL_CLUSTER_LABEL, clusterName).tag(NODE_ID_LABEL, Metrics.nodeIdToLabelValue(nodeId)).withRegistry((MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry);
    }

    private static Meter.MeterProvider<Timer> buildTimerMeterProvider(String meterName, String description, String clusterName, @Nullable Integer nodeId) {
        return Timer.builder((String)meterName).description(description).tag(VIRTUAL_CLUSTER_LABEL, clusterName).tag(NODE_ID_LABEL, Metrics.nodeIdToLabelValue(nodeId)).withRegistry((MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry);
    }

    private static Meter.MeterProvider<DistributionSummary> buildDistributionSummaryMeterProvider(String meterName, String description, String clusterName, String baseUnit, @Nullable Integer nodeId) {
        String name = meterName + SIZE_SUFFIX;
        return DistributionSummary.builder((String)name).baseUnit(baseUnit).description(description).tag(VIRTUAL_CLUSTER_LABEL, clusterName).tag(NODE_ID_LABEL, Metrics.nodeIdToLabelValue(nodeId)).withRegistry((MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry);
    }

    @Deprecated(since="0.13.0", forRemoval=true)
    public static Counter inboundDownstreamDecodedMessageCounter(String clusterName) {
        return (Counter)Counter.builder((String)KROXYLICIOUS_INBOUND_DOWNSTREAM_DECODED_MESSAGES).withRegistry((MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry).withTags(new String[]{DEPRECATED_VIRTUAL_CLUSTER_TAG, clusterName, DEPRECATED_FLOWING_TAG, DOWNSTREAM_FLOWING_VALUE});
    }

    @Deprecated(since="0.13.0", forRemoval=true)
    public static Counter inboundDownstreamMessageCounter(String clusterName) {
        return (Counter)Counter.builder((String)KROXYLICIOUS_INBOUND_DOWNSTREAM_MESSAGES).withRegistry((MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry).withTags(new String[]{DEPRECATED_VIRTUAL_CLUSTER_TAG, clusterName, DEPRECATED_FLOWING_TAG, DOWNSTREAM_FLOWING_VALUE});
    }

    @Deprecated(since="0.13.0", forRemoval=true)
    public static Meter.MeterProvider<DistributionSummary> payloadSizeBytesUpstreamSummary(String clusterName) {
        return DistributionSummary.builder((String)KROXYLICIOUS_PAYLOAD_SIZE_BYTES).baseUnit("bytes").tag(DEPRECATED_VIRTUAL_CLUSTER_TAG, clusterName).tag(DEPRECATED_FLOWING_TAG, UPSTREAM_FLOWING_VALUE).withRegistry((MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry);
    }

    @Deprecated(since="0.13.0", forRemoval=true)
    public static Meter.MeterProvider<DistributionSummary> payloadSizeBytesDownstreamSummary(String clusterName) {
        return DistributionSummary.builder((String)KROXYLICIOUS_PAYLOAD_SIZE_BYTES).baseUnit("bytes").tag(DEPRECATED_VIRTUAL_CLUSTER_TAG, clusterName).tag(DEPRECATED_FLOWING_TAG, DOWNSTREAM_FLOWING_VALUE).withRegistry((MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry);
    }

    public static void versionInfoMetric(VersionInfo versionInfo) {
        Gauge.builder((String)INFO_METRIC_NAME, () -> 1.0).description("Reports Kroxylicious version information").tag("version", versionInfo.version()).tag("commit_id", versionInfo.commitId()).strongReference(true).register((MeterRegistry)io.micrometer.core.instrument.Metrics.globalRegistry);
    }

    public static void clear() {
        CLIENT_TO_PROXY_CONNECTION_CACHE.clear();
        PROXY_TO_SERVER_CONNECTION_CACHE.clear();
    }
}

