/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.vault;

import io.confluent.csid.config.provider.common.util.Utils;
import io.confluent.csid.config.provider.vault.AuthMethod;
import io.confluent.csid.config.provider.vault.ImmutableAuthResult;
import io.confluent.csid.config.provider.vault.VaultConfigProviderConfig;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.response.AuthResponse;
import io.github.jopenlibs.vault.response.LookupResponse;
import java.util.Optional;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AuthHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthHandler.class);

    AuthHandler() {
    }

    public abstract AuthMethod method();

    public abstract AuthResult execute(VaultConfigProviderConfig var1, Vault var2) throws VaultException;

    protected AuthResult result(AuthResponse response) {
        log.debug("result() - username = '{}' authLeaseDuration = {} renewable = {} authRenewable = {}", new Object[]{response.getUsername(), response.getAuthLeaseDuration(), response.getRenewable(), response.isAuthRenewable()});
        return ImmutableAuthResult.builder().token(response.getAuthClientToken()).ttl(response.getAuthLeaseDuration()).tokenRenewable(response.getRenewable()).authRenewable(response.isAuthRenewable()).build();
    }

    protected AuthResult result(LookupResponse response) {
        log.debug("result() - username = '{}' authLeaseDuration = {} renewable = {}", new Object[]{response.getUsername(), response.getTTL(), response.isRenewable()});
        return ImmutableAuthResult.builder().token(Optional.empty()).ttl(response.getTTL()).tokenRenewable(response.isRenewable()).authRenewable(false).build();
    }

    static class AppRole
    extends AuthHandler {
        AppRole() {
        }

        @Override
        public AuthMethod method() {
            return AuthMethod.AppRole;
        }

        @Override
        public AuthResult execute(VaultConfigProviderConfig config, Vault vault) throws VaultException {
            AuthResponse response;
            if (Utils.isNullOrEmpty((String)config.mount)) {
                log.trace("execute() - calling loginByAppRole('{}', '*****')", (Object)config.role);
                response = vault.auth().loginByAppRole(config.role, config.secret);
            } else {
                log.trace("execute() - calling loginByAppRole('{}', '{}', ****)", (Object)config.mount, (Object)config.role);
                response = vault.auth().loginByAppRole(config.mount, config.role, config.secret);
            }
            return this.result(response);
        }
    }

    static class Certificate
    extends AuthHandler {
        Certificate() {
        }

        @Override
        public AuthMethod method() {
            return AuthMethod.Certificate;
        }

        @Override
        public AuthResult execute(VaultConfigProviderConfig config, Vault vault) throws VaultException {
            AuthResponse response;
            if (Utils.isNullOrEmpty((String)config.mount)) {
                log.trace("execute() - calling loginByCert()");
                response = vault.auth().loginByCert();
            } else {
                log.trace("execute() - calling loginByCert('{}')", (Object)config.mount);
                response = vault.auth().loginByUserPass(config.username, config.password, config.mount);
            }
            return this.result(response);
        }
    }

    static class UserPass
    extends AuthHandler {
        UserPass() {
        }

        @Override
        public AuthMethod method() {
            return AuthMethod.UserPass;
        }

        @Override
        public AuthResult execute(VaultConfigProviderConfig config, Vault vault) throws VaultException {
            AuthResponse response;
            if (Utils.isNullOrEmpty((String)config.mount)) {
                log.trace("execute() - calling loginByUserPass('{}', '********')", (Object)config.username);
                response = vault.auth().loginByUserPass(config.username, config.password);
            } else {
                log.trace("execute() - calling loginByUserPass('{}', '********', '{}')", (Object)config.username, (Object)config.mount);
                response = vault.auth().loginByUserPass(config.username, config.password, config.mount);
            }
            return this.result(response);
        }
    }

    static class LDAP
    extends AuthHandler {
        LDAP() {
        }

        @Override
        public AuthMethod method() {
            return AuthMethod.LDAP;
        }

        @Override
        public AuthResult execute(VaultConfigProviderConfig config, Vault vault) throws VaultException {
            AuthResponse response = Utils.isNullOrEmpty((String)config.mount) ? vault.auth().loginByLDAP(config.username, config.password) : vault.auth().loginByLDAP(config.username, config.password, config.mount);
            return this.result(response);
        }
    }

    static class Token
    extends AuthHandler {
        Token() {
        }

        @Override
        public AuthMethod method() {
            return AuthMethod.Token;
        }

        @Override
        public AuthResult execute(VaultConfigProviderConfig config, Vault vault) throws VaultException {
            LookupResponse lookupResponse = vault.auth().lookupSelf();
            return this.result(lookupResponse);
        }
    }

    @Value.Immutable
    static interface AuthResult {
        @Value.Redacted
        public Optional<String> token();

        public Optional<Long> ttl();

        public boolean tokenRenewable();

        public boolean authRenewable();
    }
}

