/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.vault;

import io.confluent.csid.config.provider.annotations.ConfigProviderKey;
import io.confluent.csid.config.provider.annotations.Description;
import io.confluent.csid.config.provider.annotations.DocumentationTip;
import io.confluent.csid.config.provider.common.AbstractConfigProvider;
import io.confluent.csid.config.provider.common.RetriableException;
import io.confluent.csid.config.provider.common.SecretRequest;
import io.confluent.csid.config.provider.vault.VaultClient;
import io.confluent.csid.config.provider.vault.VaultClientFactory;
import io.confluent.csid.config.provider.vault.VaultClientFactoryImpl;
import io.confluent.csid.config.provider.vault.VaultConfigProviderConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.response.LogicalResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="This config provider is used to retrieve secrets from the Hashicorp Vault.")
@DocumentationTip(value="Config providers can be used with anything that supports the AbstractConfig base class that is shipped with Apache Kafka.")
@ConfigProviderKey(value="vault")
public class VaultConfigProvider
extends AbstractConfigProvider<VaultConfigProviderConfig> {
    private static final Logger log = LoggerFactory.getLogger(VaultConfigProvider.class);
    VaultClientFactory vaultClientFactory = new VaultClientFactoryImpl();
    VaultClient vaultClient;
    private static final Set<Integer> RETRIABLE;

    protected VaultConfigProviderConfig config(Map<String, ?> settings) {
        return new VaultConfigProviderConfig(settings);
    }

    protected void configure() {
        this.vaultClient = this.vaultClientFactory.create((VaultConfigProviderConfig)this.config, this.executorService);
    }

    protected Map<String, String> getSecret(SecretRequest request) throws Exception {
        log.info("getSecret() - request = '{}'", (Object)request);
        try {
            LogicalResponse response = this.vaultClient.read(request);
            return response.getData();
        }
        catch (VaultException ex) {
            if (RETRIABLE.contains(ex.getHttpStatusCode())) {
                throw new RetriableException("Exception reading vault", (Throwable)ex);
            }
            throw ex;
        }
    }

    public ConfigDef config() {
        return VaultConfigProviderConfig.config();
    }

    static {
        LogHandler logHandler = new LogHandler();
        String[] julLoggers = new String[]{"com.bettercloud.vault", "sun.net.www.protocol.http.HttpURLConnection"};
        Stream.of(julLoggers).map(java.util.logging.Logger::getLogger).forEach(l -> l.addHandler(logHandler));
        RETRIABLE = Collections.unmodifiableSet(new LinkedHashSet<Integer>(Arrays.asList(500, 502, 503)));
    }

    private static class LogHandler
    extends Handler {
        private LogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            if (Level.ALL.equals(record.getLevel())) {
                log.trace(record.getMessage());
            } else if (Level.FINEST.equals(record.getLevel())) {
                log.debug(record.getMessage());
            } else if (Level.FINER.equals(record.getLevel())) {
                log.debug(record.getMessage());
            } else if (Level.FINE.equals(record.getLevel())) {
                log.debug(record.getMessage());
            } else if (Level.CONFIG.equals(record.getLevel())) {
                log.info(record.getMessage());
            } else if (Level.INFO.equals(record.getLevel())) {
                log.info(record.getMessage());
            } else if (Level.WARNING.equals(record.getLevel())) {
                log.warn(record.getMessage());
            } else if (Level.SEVERE.equals(record.getLevel())) {
                log.error(record.getMessage());
            } else if (Level.OFF.equals(record.getLevel())) {
                log.error(record.getMessage());
            } else {
                log.debug(record.getMessage());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

