/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.csid.config.provider.common.AbstractConfigProvider;
import io.confluent.csid.config.provider.common.AbstractConfigProviderConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJacksonConfigProvider<CONFIG extends AbstractConfigProviderConfig>
extends AbstractConfigProvider<CONFIG> {
    private static final Logger log = LoggerFactory.getLogger(AbstractJacksonConfigProvider.class);
    protected ObjectMapper mapper;

    @Override
    protected void configure() {
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
    }

    protected Map<String, String> readJsonValue(ByteBuffer content) throws IOException {
        byte[] buffer = new byte[content.remaining()];
        content.get(buffer);
        try (JsonParser parser = this.mapper.createParser(buffer);){
            Map<String, String> map = this.readJsonValue(parser);
            return map;
        }
    }

    protected Map<String, String> readJsonValue(String content) throws IOException {
        try (JsonParser parser = this.mapper.createParser(content);){
            Map<String, String> map = this.readJsonValue(parser);
            return map;
        }
    }

    protected Map<String, String> readJsonValue(byte[] content) throws IOException {
        try (JsonParser parser = this.mapper.createParser(content);){
            Map<String, String> map = this.readJsonValue(parser);
            return map;
        }
    }

    protected Map<String, String> readJsonValue(JsonParser parser) throws IOException {
        JsonNode node = (JsonNode)this.mapper.readValue(parser, JsonNode.class);
        if (null == node || !node.isObject()) {
            String exampleText = this.mapper.writeValueAsString((Object)this.mapper.createObjectNode().put("username", "username").put("password", "s3cr3t").put("hostname", "db01.example.com").put("port", "54321"));
            throw new IllegalStateException(String.format("Secret body must be a json object with string values. For example:\n%s", exampleText));
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        ObjectNode objectNode = (ObjectNode)node;
        Iterator fieldNames = objectNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldValue;
            String fieldName = (String)fieldNames.next();
            JsonNode fieldNode = objectNode.get(fieldName);
            if (fieldNode.isTextual()) {
                fieldValue = fieldNode.textValue();
            } else {
                if (fieldNode.isNull()) {
                    log.trace("readJsonValue() - Dropping field '{}' because value is null.", (Object)fieldName);
                    continue;
                }
                log.warn("readJsonValue() - Converting field '{}' from '{}' with .toString(). Secret values must only be strings.", (Object)fieldName, (Object)fieldNode.getNodeType());
                fieldValue = fieldNode.toString();
            }
            result.put(fieldName, fieldValue);
        }
        return result;
    }
}

