/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common;

import io.confluent.csid.config.provider.common.Subscription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="Subscription.Key", generator="Immutables")
public final class ImmutableKey
implements Subscription.Key {
    private final Set<String> keys;

    private ImmutableKey(Set<String> keys) {
        this.keys = keys;
    }

    @Override
    public Set<String> keys() {
        return this.keys;
    }

    public final ImmutableKey withKeys(String ... elements) {
        Set<String> newValue = ImmutableKey.createUnmodifiableSet(ImmutableKey.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableKey(newValue);
    }

    public final ImmutableKey withKeys(Iterable<String> elements) {
        if (this.keys == elements) {
            return this;
        }
        Set<String> newValue = ImmutableKey.createUnmodifiableSet(ImmutableKey.createSafeList(elements, true, false));
        return new ImmutableKey(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKey && this.equalTo(0, (ImmutableKey)another);
    }

    private boolean equalTo(int synthetic, ImmutableKey another) {
        return this.keys.equals(another.keys);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.keys.hashCode();
        return h;
    }

    public String toString() {
        return "Key{keys=" + this.keys + "}";
    }

    public static ImmutableKey copyOf(Subscription.Key instance) {
        if (instance instanceof ImmutableKey) {
            return (ImmutableKey)instance;
        }
        return ImmutableKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="Subscription.Key", generator="Immutables")
    public static final class Builder {
        private List<String> keys = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(Subscription.Key instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllKeys(instance.keys());
            return this;
        }

        public final Builder addKeys(String element) {
            this.keys.add(Objects.requireNonNull(element, "keys element"));
            return this;
        }

        public final Builder addKeys(String ... elements) {
            for (String element : elements) {
                this.keys.add(Objects.requireNonNull(element, "keys element"));
            }
            return this;
        }

        public final Builder keys(Iterable<String> elements) {
            this.keys.clear();
            return this.addAllKeys(elements);
        }

        public final Builder addAllKeys(Iterable<String> elements) {
            for (String element : elements) {
                this.keys.add(Objects.requireNonNull(element, "keys element"));
            }
            return this;
        }

        public ImmutableKey build() {
            return new ImmutableKey(ImmutableKey.createUnmodifiableSet(this.keys));
        }
    }
}

