/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.config.provider.common;

import io.confluent.csid.config.provider.common.SecretRequest;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="SecretRequest", generator="Immutables")
public final class ImmutableSecretRequest
implements SecretRequest {
    private final String raw;
    private final String path;
    private final Optional<String> version;

    private ImmutableSecretRequest(Builder builder) {
        this.raw = builder.raw;
        this.path = builder.path;
        this.version = builder.version != null ? builder.version : Objects.requireNonNull(SecretRequest.super.version(), "version");
    }

    private ImmutableSecretRequest(String raw, String path, Optional<String> version) {
        this.raw = raw;
        this.path = path;
        this.version = version;
    }

    @Override
    public String raw() {
        return this.raw;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Optional<String> version() {
        return this.version;
    }

    public final ImmutableSecretRequest withRaw(String value) {
        String newValue = Objects.requireNonNull(value, "raw");
        if (this.raw.equals(newValue)) {
            return this;
        }
        return new ImmutableSecretRequest(newValue, this.path, this.version);
    }

    public final ImmutableSecretRequest withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableSecretRequest(this.raw, newValue, this.version);
    }

    public final ImmutableSecretRequest withVersion(Optional<String> value) {
        Optional<String> newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableSecretRequest(this.raw, this.path, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecretRequest && this.equalTo(0, (ImmutableSecretRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecretRequest another) {
        return this.raw.equals(another.raw) && this.path.equals(another.path) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.raw.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return "SecretRequest{raw=" + this.raw + ", path=" + this.path + ", version=" + this.version + "}";
    }

    public static ImmutableSecretRequest copyOf(SecretRequest instance) {
        if (instance instanceof ImmutableSecretRequest) {
            return (ImmutableSecretRequest)instance;
        }
        return ImmutableSecretRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SecretRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_RAW = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private long initBits = 3L;
        private String raw;
        private String path;
        private Optional<String> version;

        private Builder() {
        }

        public final Builder from(SecretRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.raw(instance.raw());
            this.path(instance.path());
            this.version(instance.version());
            return this;
        }

        public final Builder raw(String raw) {
            this.raw = Objects.requireNonNull(raw, "raw");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder version(Optional<String> version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        public ImmutableSecretRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecretRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("raw");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build SecretRequest, some of required attributes are not set " + attributes;
        }
    }
}

