/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class Attributes
implements JsonSerializable<Attributes> {
    private Boolean enabled;
    private Long notBefore;
    private Long expires;
    private Long created;
    private Long updated;

    public Boolean isEnabled() {
        return this.enabled;
    }

    public Attributes setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime getNotBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.notBefore), ZoneOffset.UTC);
    }

    public Attributes setNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore == null ? null : Long.valueOf(notBefore.toEpochSecond());
        return this;
    }

    public OffsetDateTime getExpires() {
        if (this.expires == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expires), ZoneOffset.UTC);
    }

    public Attributes setExpires(OffsetDateTime expires) {
        this.expires = expires == null ? null : Long.valueOf(expires.toEpochSecond());
        return this;
    }

    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    Attributes setCreated(OffsetDateTime created) {
        this.created = created == null ? null : Long.valueOf(created.toEpochSecond());
        return this;
    }

    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    Attributes setUpdated(OffsetDateTime updated) {
        this.updated = updated == null ? null : Long.valueOf(updated.toEpochSecond());
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("nbf", (Number)this.notBefore);
        jsonWriter.writeNumberField("exp", (Number)this.expires);
        return jsonWriter.writeEndObject();
    }

    public static Attributes fromJson(JsonReader jsonReader) throws IOException {
        return (Attributes)jsonReader.readObject(reader -> {
            Attributes deserializedAttributes = new Attributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedAttributes.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    deserializedAttributes.notBefore = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    deserializedAttributes.expires = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedAttributes.created = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedAttributes.updated = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAttributes;
        });
    }
}

