/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.codegen;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiCodeGenerator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiCodeGenerator.class);
    protected final String templatePath;
    protected final String outputClassName;

    protected ApiCodeGenerator(String templatePath, String outputClassName) {
        this.templatePath = templatePath;
        this.outputClassName = outputClassName;
    }

    public static void main(String[] args) {
        throw new UnsupportedOperationException("ApiCodeGenerator is abstract. Use specific implementations like ErrorResponseApiCodeGenerator, or configure the generator class through Maven plugin parameters.");
    }

    public void generateCode() {
        try {
            LOGGER.info("Step 1: Discovering APIs using reflection...");
            List<T> apis = this.discoverApis();
            if (apis.isEmpty()) {
                LOGGER.warn("No APIs found. Cannot generate code.");
                return;
            }
            LOGGER.info("Step 2: Preparing template data model...");
            List<String> imports = this.prepareImports(apis);
            LOGGER.info("Step 3: Configuring FreeMarker...");
            Configuration cfg = this.configureFreeMarker();
            LOGGER.info("Step 4: Processing FreeMarker template...");
            String generatedCode = this.processTemplate(cfg, imports, apis);
            LOGGER.info("Step 5: Writing generated code...");
            this.writeGeneratedCode(generatedCode);
            LOGGER.info("Successfully generated code with {} APIs", (Object)apis.size());
        }
        catch (TemplateException | IOException e) {
            LOGGER.error("Failed to generate code", e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error during code generation", (Throwable)e);
        }
    }

    protected abstract List<T> discoverApis();

    protected abstract String getOutputFilePath();

    protected abstract List<String> prepareImports(List<T> var1);

    private Configuration configureFreeMarker() throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_32);
        cfg.setClassForTemplateLoading(this.getClass(), "/");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        return cfg;
    }

    private String processTemplate(Configuration cfg, List<String> imports, List<T> apis) throws IOException, TemplateException {
        Template template = cfg.getTemplate(this.templatePath);
        HashMap<String, List<String>> dataModel = new HashMap<String, List<String>>();
        dataModel.put("imports", imports);
        dataModel.put("apis", apis);
        StringWriter out = new StringWriter();
        template.process(dataModel, (Writer)out);
        return out.toString();
    }

    private void writeGeneratedCode(String generatedCode) throws IOException {
        Path outputPath = Paths.get(this.getOutputFilePath(), new String[0]);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        Files.writeString(outputPath, (CharSequence)generatedCode, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

