/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.app;

import io.confluent.gateway.common.util.FileUtil;
import io.confluent.gateway.config.GatewayConfigParser;
import io.confluent.gateway.config.GatewayConfiguration;
import io.confluent.gateway.configadapter.ConfigurationAdapter;
import io.kroxylicious.proxy.config.ConfigParser;
import io.kroxylicious.proxy.config.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(ConfigurationManager.class);
    private final GatewayConfigParser gatewayConfigParser = new GatewayConfigParser();
    private final ConfigParser krxConfigParser = new ConfigParser();
    private final Logger logger;

    public ConfigurationManager() {
        this(DEFAULT_LOGGER);
    }

    public ConfigurationManager(Logger logger) {
        this.logger = logger;
    }

    public GatewayConfiguration parseGatewayConfig(File configFile) throws IOException {
        GatewayConfiguration gatewayConfiguration;
        block8: {
            InputStream inputStream = Files.newInputStream(configFile.toPath(), new OpenOption[0]);
            try {
                gatewayConfiguration = this.gatewayConfigParser.parse(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error("Exception while parsing gateway configuration file: {}", (Object)configFile, (Object)e);
                    throw e;
                }
            }
            inputStream.close();
        }
        return gatewayConfiguration;
    }

    public Path createKrxConfig(GatewayConfiguration gatewayConfiguration, File configFile) throws IOException {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
        String timestampTag = now.format(formatter);
        String translatedConfigFileName = "gateway-config.krx-" + timestampTag;
        Path tempFile = FileUtil.createSecureTempFile((String)translatedConfigFileName, (String)".yaml", (boolean)true);
        try {
            ConfigurationAdapter configAdapter = new ConfigurationAdapter(gatewayConfiguration);
            Map<String, Object> config = configAdapter.toKroxyliciousConfiguration();
            FileUtil.writeYamlFile((String)tempFile.toString(), config);
            this.logger.info("Kroxylicious config written to: {}", (Object)tempFile.toAbsolutePath());
            if (this.logger.isDebugEnabled()) {
                String yamlContent = Files.readString(tempFile.toAbsolutePath());
                this.logger.debug("Kroxylicious configuration:\n{}", (Object)yamlContent);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while parsing gateway configuration file: {}", (Object)configFile, (Object)e);
            throw e;
        }
        return tempFile;
    }

    public Configuration parseKrxConfig(InputStream stream) {
        return this.krxConfigParser.parseConfiguration(stream);
    }

    @Generated
    public GatewayConfigParser getGatewayConfigParser() {
        return this.gatewayConfigParser;
    }

    @Generated
    public ConfigParser getKrxConfigParser() {
        return this.krxConfigParser;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }
}

