/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.config;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.confluent.gateway.config.GatewayConfiguration;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;

public class GatewayConfigParser {
    private static final ObjectMapper mapper = ((YAMLMapper.Builder)YAMLMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();

    public GatewayConfiguration parse(String config) {
        if (StringUtils.isBlank((CharSequence)config)) {
            throw new GatewayConfigParseException("Configuration string cannot be null or empty");
        }
        try {
            return GatewayConfiguration.withDefaults((GatewayConfiguration)mapper.readValue(config, GatewayConfiguration.class));
        }
        catch (IOException e) {
            throw new GatewayConfigParseException("Couldn't parse gateway configuration", e);
        }
    }

    public GatewayConfiguration parse(InputStream inputStream) {
        if (inputStream == null) {
            throw new GatewayConfigParseException("Gateway configuration InputStream cannot be null");
        }
        try {
            return GatewayConfiguration.withDefaults((GatewayConfiguration)mapper.readValue(inputStream, GatewayConfiguration.class));
        }
        catch (IOException e) {
            throw new GatewayConfigParseException("Couldn't parse gateway configuration", e);
        }
    }

    static {
        mapper.findAndRegisterModules();
    }
}

