/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter;

import io.confluent.gateway.config.Gateway;
import io.confluent.gateway.config.GatewayConfiguration;
import io.confluent.gateway.configadapter.builder.KroxyliciousConfigurationBuilder;
import io.confluent.gateway.configadapter.validation.GatewayConfigurationValidator;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationAdapter.class);
    private final Gateway gateway;
    private final GatewayConfigurationValidator validator;
    private final KroxyliciousConfigurationBuilder configurationBuilder;

    public ConfigurationAdapter(@NonNull GatewayConfiguration gatewayConfiguration) {
        if (gatewayConfiguration == null) {
            throw new NullPointerException("gatewayConfiguration is marked non-null but is null");
        }
        this.gateway = gatewayConfiguration.gateway();
        this.validator = new GatewayConfigurationValidator();
        this.configurationBuilder = new KroxyliciousConfigurationBuilder(this.gateway);
        this.validateConfiguration();
        LOGGER.info("ConfigurationAdapter initialized successfully for gateway configuration");
    }

    public Map<String, Object> toKroxyliciousConfiguration() {
        LOGGER.debug("Converting gateway configuration to Kroxylicious format");
        return this.configurationBuilder.build(this.gateway);
    }

    private void validateConfiguration() {
        LOGGER.debug("Validating gateway configuration");
        this.validator.validateAndThrow(this.gateway);
        LOGGER.debug("Gateway configuration validation completed successfully");
    }
}

