/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.builder;

import io.confluent.gateway.config.Gateway;
import io.confluent.gateway.config.route.Route;
import io.confluent.gateway.config.secretstore.SecretStore;
import io.confluent.gateway.configadapter.util.ConfigUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FilterDefinitionBuilder {
    private final Map<String, SecretStore> secretStoreMap;
    private final Map<String, List<String>> routeFiltersMap;

    public FilterDefinitionBuilder(Map<String, SecretStore> secretStoreMap) {
        this.secretStoreMap = secretStoreMap;
        this.routeFiltersMap = new LinkedHashMap<String, List<String>>();
    }

    public List<Map<String, Object>> build(Gateway gateway) {
        ArrayList<Map<String, Object>> filterDefinitions = new ArrayList<Map<String, Object>>();
        gateway.routes().forEach(route -> {
            if (route.security() != null && route.security().auth().isSwap()) {
                Map<String, Object> filterDefinition = this.buildAuthSwapFilterDefinition((Route)route);
                filterDefinitions.add(filterDefinition);
            }
        });
        return filterDefinitions;
    }

    private Map<String, Object> buildAuthSwapFilterDefinition(Route route) {
        LinkedHashMap<String, Object> filterDefinition = new LinkedHashMap<String, Object>();
        String filterName = route.name() + "-swap-filter";
        filterDefinition.put("name", filterName);
        filterDefinition.put("type", "AuthSwap");
        filterDefinition.put("config", this.buildSwapFilterConfig(route));
        this.routeFiltersMap.computeIfAbsent(route.name(), k -> new ArrayList()).add(filterDefinition.get("name").toString());
        return filterDefinition;
    }

    private Map<String, Object> buildSwapFilterConfig(Route route) {
        LinkedHashMap<String, Object> swapConfig = new LinkedHashMap<String, Object>(route.security().swapConfig());
        if (ConfigUtil.isNoneClusterAuth(swapConfig)) {
            return swapConfig;
        }
        Object secretStoreKey = swapConfig.get("secretStore");
        if (secretStoreKey == null) {
            throw new IllegalArgumentException("Secret store key is missing from swap config for route: " + route.name());
        }
        String secretStoreRef = secretStoreKey.toString();
        swapConfig.put("secretStore", this.secretStoreMap.get(secretStoreRef));
        return swapConfig;
    }

    public Map<String, List<String>> getRouteFiltersMap() {
        return new LinkedHashMap<String, List<String>>(this.routeFiltersMap);
    }
}

