/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.mapbuilder;

import io.confluent.gateway.config.Gateway;
import io.confluent.gateway.config.secretstore.SecretStore;
import io.confluent.gateway.config.streamingdomain.BootstrapServer;
import io.confluent.gateway.config.streamingdomain.StreamingDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConfigMapBuilder {
    private ConfigMapBuilder() {
    }

    public static Map<String, SecretStore> buildSecretStoreMap(Gateway gateway) {
        return gateway.secretStores().stream().collect(Collectors.toMap(SecretStore::name, Function.identity()));
    }

    public static Map<String, StreamingDomain> buildStreamingDomainMap(Gateway gateway) {
        return gateway.streamingDomains().stream().collect(Collectors.toMap(StreamingDomain::name, Function.identity()));
    }

    public static Map<String, Map<String, BootstrapServer>> buildBootstrapServerMap(Gateway gateway) {
        HashMap<String, Map<String, BootstrapServer>> bootstrapServerMap = new HashMap<String, Map<String, BootstrapServer>>();
        gateway.streamingDomains().forEach(streamingDomain -> {
            Map serverMap = streamingDomain.kafkaCluster().bootstrapServers().stream().collect(Collectors.toMap(BootstrapServer::id, Function.identity()));
            bootstrapServerMap.put(streamingDomain.name(), serverMap);
        });
        return bootstrapServerMap;
    }
}

