/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.validation;

import io.confluent.gateway.config.Gateway;
import io.confluent.gateway.config.exception.GatewayConfigParseException;
import io.confluent.gateway.configadapter.validation.ConfigurationValidator;
import io.confluent.gateway.configadapter.validation.ConfigurationValidatorFactory;
import io.confluent.gateway.configadapter.validation.ValidationResult;
import java.util.List;
import lombok.NonNull;

public class GatewayConfigurationValidator {
    private final List<ConfigurationValidator> validators;

    public GatewayConfigurationValidator() {
        this(ConfigurationValidatorFactory.createDefaultValidators());
    }

    public GatewayConfigurationValidator(List<ConfigurationValidator> validators) {
        this.validators = validators;
    }

    public ValidationResult validate(@NonNull Gateway gateway) {
        if (gateway == null) {
            throw new NullPointerException("gateway is marked non-null but is null");
        }
        ValidationResult result = new ValidationResult();
        this.validators.forEach(validator -> result.addErrors(validator.validate(gateway)));
        return result;
    }

    public void validateAndThrow(Gateway gateway) {
        ValidationResult result = this.validate(gateway);
        if (result.hasErrors()) {
            throw new GatewayConfigParseException("Errors found during configuration validation: " + result.getErrorMessages());
        }
    }
}

