/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.validation;

import io.confluent.gateway.config.Gateway;
import io.confluent.gateway.config.route.Route;
import io.confluent.gateway.config.secretstore.SecretStore;
import io.confluent.gateway.config.streamingdomain.BootstrapServer;
import io.confluent.gateway.config.streamingdomain.StreamingDomain;
import io.confluent.gateway.configadapter.util.ConfigUtil;
import io.confluent.gateway.configadapter.validation.ConfigurationValidator;
import io.confluent.gateway.configadapter.validation.ValidationError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteValidator
implements ConfigurationValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteValidator.class);

    @Override
    public List<ValidationError> validate(Gateway gateway) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        HashSet routeNames = new HashSet();
        Map<String, StreamingDomain> streamingDomainMap = gateway.streamingDomains().stream().collect(Collectors.toMap(StreamingDomain::name, sd -> sd));
        Map<String, SecretStore> secretStoreMap = gateway.secretStores().stream().collect(Collectors.toMap(SecretStore::name, ss -> ss));
        gateway.routes().forEach(route -> {
            if (routeNames.contains(route.name())) {
                errors.add(new ValidationError("Duplicate route name: " + route.name(), "Route validation"));
            } else {
                routeNames.add(route.name());
            }
            this.validateRouteConfig((Route)route, streamingDomainMap, secretStoreMap, (List<ValidationError>)errors);
        });
        return errors;
    }

    private void validateRouteConfig(Route route, Map<String, StreamingDomain> streamingDomainMap, Map<String, SecretStore> secretStoreMap, List<ValidationError> errors) {
        this.validateStreamingDomainReference(route, streamingDomainMap, errors);
        this.validateSecurityConfiguration(route, secretStoreMap, errors);
        this.validateBrokerIdentificationStrategy(route, errors);
    }

    private void validateStreamingDomainReference(Route route, Map<String, StreamingDomain> streamingDomainMap, List<ValidationError> errors) {
        if (!streamingDomainMap.containsKey(route.streamingDomain().name())) {
            errors.add(new ValidationError("Streaming domain does not exist for route: " + route.streamingDomain().name(), route.alias()));
        } else {
            StreamingDomain streamingDomain = streamingDomainMap.get(route.streamingDomain().name());
            List<BootstrapServer> bootstrapServers = streamingDomain.kafkaCluster().bootstrapServers();
            if (bootstrapServers.stream().noneMatch(bs -> bs.id().equals(route.streamingDomain().bootstrapServerId()))) {
                errors.add(new ValidationError("Bootstrap server ID does not exist in streaming domain: " + route.streamingDomain().bootstrapServerId(), route.alias()));
            }
        }
    }

    private void validateSecurityConfiguration(Route route, Map<String, SecretStore> secretStoreMap, List<ValidationError> errors) {
        if (route.security() != null && route.security().auth().isSwap()) {
            Map<String, Object> swapConfig = route.security().swapConfig();
            if (ObjectUtils.isEmpty(swapConfig)) {
                errors.add(new ValidationError("Swap config is required for route security: " + route.name(), route.alias()));
                return;
            }
            this.validateSecretStoreReference(route, swapConfig, secretStoreMap, errors);
            this.validateTlsForAuthSwap(route, swapConfig, errors);
        }
    }

    private void validateSecretStoreReference(Route route, Map<String, Object> swapConfig, Map<String, SecretStore> secretStoreMap, List<ValidationError> errors) {
        if (ConfigUtil.isNoneClusterAuth(swapConfig)) {
            if (swapConfig.containsKey("secretStore")) {
                errors.add(new ValidationError("Secret store should not be specified for route with NONE cluster auth", route.alias()));
            }
            return;
        }
        if (swapConfig.containsKey("secretStore")) {
            String secretStoreRef = swapConfig.get("secretStore").toString();
            if (!secretStoreMap.containsKey(secretStoreRef)) {
                errors.add(new ValidationError("Secret store does not exist for route security: " + secretStoreRef, route.alias()));
            }
        } else {
            errors.add(new ValidationError("Secret store reference is required in swap config for route: " + route.name(), route.alias()));
        }
    }

    private void validateTlsForAuthSwap(Route route, Map<String, Object> swapConfig, List<ValidationError> errors) {
        if (route.security().auth().isSwap() && !ObjectUtils.isEmpty(swapConfig)) {
            Map clientAuthMap;
            if (!swapConfig.containsKey("clientAuth")) {
                errors.add(new ValidationError("clientAuth should be configured for auth swap for route: " + route.name(), route.alias()));
                return;
            }
            Object clientAuthObj = swapConfig.get("clientAuth");
            if (clientAuthObj instanceof Map && (clientAuthMap = (Map)clientAuthObj).containsKey("ssl") && route.security().ssl() == null) {
                errors.add(new ValidationError("route:" + route.name() + " should have security.ssl configured for ssl auth swap.", route.alias()));
            }
        }
    }

    private void validateBrokerIdentificationStrategy(Route route, List<ValidationError> errors) {
        if (route.brokerIdentificationStrategy().isHostStrategy()) {
            if (route.security().ssl() == null || route.security().ssl().keystore() == null) {
                errors.add(new ValidationError("SSL keystore must be defined for host identification strategy.", route.alias()));
            }
            if (!route.brokerIdentificationStrategy().pattern().contains("$(nodeId)")) {
                errors.add(new ValidationError("Broker identification pattern must contain $(nodeId) for host strategy.", route.alias()));
            }
        } else if (!StringUtils.isEmpty((CharSequence)route.brokerIdentificationStrategy().pattern())) {
            LOGGER.warn("for port based strategy, pattern is not used. Ignoring pattern: {} for route: {}", (Object)route.brokerIdentificationStrategy().pattern(), (Object)route.name());
        }
    }
}

