/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.gateway.configadapter.validation;

import io.confluent.gateway.config.Gateway;
import io.confluent.gateway.configadapter.validation.ConfigurationValidator;
import io.confluent.gateway.configadapter.validation.ValidationError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class StreamingDomainValidator
implements ConfigurationValidator {
    @Override
    public List<ValidationError> validate(Gateway gateway) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        HashSet streamingDomainNames = new HashSet();
        gateway.streamingDomains().forEach(streamingDomain -> {
            if (streamingDomainNames.contains(streamingDomain.name())) {
                errors.add(new ValidationError("Duplicate streaming domain name: " + streamingDomain.name(), ""));
            } else {
                streamingDomainNames.add(streamingDomain.name());
            }
        });
        return errors;
    }
}

