#!/bin/bash
# Setup script to make gateway scripts executable

echo "Setting up Gateway startup scripts..."

# Get the script directory
script_dir="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

# Make scripts executable
chmod +x "$script_dir/gateway-run-class"
chmod +x "$script_dir/gateway"

echo "✓ Made gateway-run-class executable"
echo "✓ Made gateway executable"

echo ""
echo "Gateway startup scripts are now ready!"
echo ""
echo "Next steps:"
echo "1. Build the project: mvn clean package"
echo "2. Run the gateway: ./bin/gateway -c config/gateway-config.yaml"
echo ""
echo "For more information, see bin/README.md"