/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.agent.monitoring;

import io.confluent.agent.monitoring.VolumeMBean;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Volume
implements VolumeMBean {
    private static final Logger log = LoggerFactory.getLogger(Volume.class);
    private final String dir;
    private final FileStore store;

    public Volume(String dir) throws IOException {
        this.dir = dir;
        this.store = Files.getFileStore(Paths.get(dir, new String[0]));
    }

    @Override
    public long getTotal() {
        long total = -1L;
        try {
            total = this.store.getTotalSpace();
        }
        catch (IOException e) {
            log.error("Error while getting total disk space", (Throwable)e);
        }
        return total;
    }

    @Override
    public long getUsed() {
        long used = -1L;
        try {
            used = this.store.getTotalSpace() - this.store.getUnallocatedSpace();
        }
        catch (IOException e) {
            log.error("Error while getting total disk space", (Throwable)e);
        }
        return used;
    }

    @Override
    public long getAvailable() {
        long avail = -1L;
        try {
            avail = this.store.getUsableSpace();
        }
        catch (IOException e) {
            log.error("Error while getting total disk space", (Throwable)e);
        }
        return avail;
    }

    @Override
    public double getPercentUsed() {
        return (double)this.getUsed() / (double)this.getTotal() * 100.0;
    }

    @Override
    public double getPercentAvailable() {
        return (double)this.getAvailable() / (double)this.getTotal() * 100.0;
    }

    @Override
    public String getMountpoint() {
        return this.dir;
    }

    @Override
    public String getDeviceName() {
        return this.store.name();
    }

    public String toString() {
        return "Volume{store=" + this.store.toString() + ", total=" + this.getTotal() + ", used=" + this.getUsed() + ", available=" + this.getAvailable() + ", percentUsed=" + this.getPercentUsed() + ", percentAvailable=" + this.getPercentAvailable() + ", mountpoint='" + this.getMountpoint() + '\'' + ", deviceName='" + this.getDeviceName() + '\'' + '}';
    }
}

