/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.admin.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.confluent.admin.utils.ZookeeperConnectionWatcher;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStatus {
    private static final Logger log = LoggerFactory.getLogger(ClusterStatus.class);
    public static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    public static final String BROKERS_IDS_PATH = "/brokers/ids";
    public static final int BROKER_METADATA_REQUEST_BACKOFF_MS = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZookeeperReady(String zkConnectString, int timeoutMs) {
        log.debug("Check if Zookeeper is ready: {} ", (Object)zkConnectString);
        ZooKeeper zookeeper = null;
        try {
            boolean timedOut;
            CountDownLatch waitForConnection = new CountDownLatch(1);
            boolean isSaslEnabled = false;
            if (System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, null) != null) {
                isSaslEnabled = true;
                log.info("SASL is enabled. java.security.auth.login.config={}", (Object)System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG));
            }
            ZookeeperConnectionWatcher connectionWatcher = new ZookeeperConnectionWatcher(waitForConnection, isSaslEnabled);
            zookeeper = new ZooKeeper(zkConnectString, timeoutMs, (Watcher)connectionWatcher);
            boolean bl = timedOut = !waitForConnection.await(timeoutMs, TimeUnit.MILLISECONDS);
            if (timedOut) {
                log.error("Timed out waiting for connection to Zookeeper server [{}].", (Object)zkConnectString);
                boolean bl2 = false;
                return bl2;
            }
            if (!connectionWatcher.isSuccessful()) {
                log.error("Error occurred while connecting to Zookeeper server[{}]. {} ", (Object)zkConnectString, (Object)connectionWatcher.getFailureMessage());
                boolean bl3 = false;
                return bl3;
            }
            boolean bl4 = true;
            return bl4;
        }
        catch (Exception e) {
            log.error("Error while waiting for Zookeeper client to connect to the server [{}].", (Object)zkConnectString, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (zookeeper != null) {
                try {
                    zookeeper.close();
                }
                catch (InterruptedException e) {
                    log.error("Error while shutting down Zookeeper client.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static boolean isKafkaReady(Map<String, String> config, int minBrokerCount, int timeoutMs) {
        AdminClient adminClient = AdminClient.create(new HashMap<String, String>(config));
        long begin = System.currentTimeMillis();
        long remainingWaitMs = timeoutMs;
        Collection brokers = new ArrayList();
        while (remainingWaitMs > 0L) {
            try {
                brokers = (Collection)adminClient.describeCluster(new DescribeClusterOptions().timeoutMs(Integer.valueOf((int)Math.min(Integer.MAX_VALUE, remainingWaitMs)))).nodes().get();
                log.debug("Broker list: {}", brokers != null ? brokers : "[]");
                if (brokers != null && brokers.size() >= minBrokerCount) {
                    return true;
                }
            }
            catch (Exception e) {
                log.error("Error while getting broker list.", (Throwable)e);
            }
            ClusterStatus.sleep(Math.min(1000L, remainingWaitMs));
            log.info("Expected {} brokers but found only {}. Trying to query Kafka for metadata again ...", (Object)minBrokerCount, (Object)(brokers == null ? 0 : brokers.size()));
            long elapsed = System.currentTimeMillis() - begin;
            remainingWaitMs = (long)timeoutMs - elapsed;
        }
        log.error("Expected {} brokers but found only {}. Brokers found {}.", new Object[]{minBrokerCount, brokers == null ? 0 : brokers.size(), brokers != null ? brokers : "[]"});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getBrokerMetadataFromZookeeper(String zkConnectString, int timeoutMs) throws KeeperException, InterruptedException, IOException {
        log.debug("Get a bootstrap broker from Zookeeper [{}].", (Object)zkConnectString);
        ZooKeeper zookeeper = null;
        try {
            zookeeper = ClusterStatus.createZookeeperClient(zkConnectString, timeoutMs);
            boolean isBrokerRegisted = ClusterStatus.isKafkaRegisteredInZookeeper(zookeeper, timeoutMs);
            if (!isBrokerRegisted) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List<String> brokers = ClusterStatus.getRawKafkaMetadataFromZK(zookeeper, timeoutMs);
            ArrayList<String> brokerMetadata = new ArrayList<String>();
            for (String broker : brokers) {
                String brokerIdPath = String.format("%s/%s", BROKERS_IDS_PATH, broker);
                byte[] brokerIdBytes = zookeeper.getData(brokerIdPath, false, null);
                brokerMetadata.add(new String(brokerIdBytes, StandardCharsets.UTF_8));
            }
            ArrayList<String> arrayList = brokerMetadata;
            return arrayList;
        }
        finally {
            if (zookeeper != null) {
                try {
                    zookeeper.close();
                }
                catch (InterruptedException e) {
                    log.error("Error while shutting down Zookeeper client.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static List<String> getRawKafkaMetadataFromZK(ZooKeeper zookeeper, int timeoutMs) throws InterruptedException, KeeperException {
        boolean waitForBrokerTimedOut;
        final CountDownLatch waitForBroker = new CountDownLatch(1);
        final CopyOnWriteArrayList<String> brokers = new CopyOnWriteArrayList<String>();
        zookeeper.getChildren(BROKERS_IDS_PATH, new Watcher(){

            public void process(WatchedEvent event) {
                log.debug("Got event when checking for children of /brokers/ids. type={} path={}", (Object)event.getType(), (Object)event.getPath());
                if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                    waitForBroker.countDown();
                }
            }
        }, new AsyncCallback.ChildrenCallback(){

            public void processResult(int rc, String path, Object ctx, List<String> children) {
                log.debug("ChildrenCallback got data for path={} children={}", (Object)path, children);
                if (children != null && children.size() > 0) {
                    children.addAll(brokers);
                    waitForBroker.countDown();
                }
            }
        }, null);
        boolean bl = waitForBrokerTimedOut = !waitForBroker.await(timeoutMs, TimeUnit.MILLISECONDS);
        if (waitForBrokerTimedOut) {
            String message = String.format("Timed out waiting for Kafka to register brokers in Zookeeper. timeout (ms) = %s", timeoutMs);
            throw new TimeoutException(message);
        }
        if (brokers.isEmpty()) {
            List children = zookeeper.getChildren(BROKERS_IDS_PATH, false, null);
            brokers.addAll(children);
        }
        return brokers;
    }

    private static boolean isKafkaRegisteredInZookeeper(ZooKeeper zookeeper, int timeoutMs) throws InterruptedException {
        boolean kafkaRegistrationTimedOut;
        final CountDownLatch kafkaRegistrationSignal = new CountDownLatch(1);
        zookeeper.exists(BROKERS_IDS_PATH, new Watcher(){

            public void process(WatchedEvent event) {
                log.debug("Got event when checking for existence of /brokers/ids. type={} path={}", (Object)event.getType(), (Object)event.getPath());
                if (event.getType() == Watcher.Event.EventType.NodeCreated) {
                    kafkaRegistrationSignal.countDown();
                }
            }
        }, new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                log.debug("StatsCallback got data for path={}, stat={}", (Object)path, (Object)stat);
                if (stat != null) {
                    kafkaRegistrationSignal.countDown();
                }
            }
        }, null);
        boolean bl = kafkaRegistrationTimedOut = !kafkaRegistrationSignal.await(timeoutMs, TimeUnit.MILLISECONDS);
        if (kafkaRegistrationTimedOut) {
            String message = String.format("Timed out waiting for Kafka to create /brokers/ids in Zookeeper. timeout (ms) = %s", timeoutMs);
            throw new TimeoutException(message);
        }
        return true;
    }

    private static ZooKeeper createZookeeperClient(String zkConnectString, int timeoutMs) throws IOException, InterruptedException {
        boolean timedOut;
        CountDownLatch waitForConnection = new CountDownLatch(1);
        boolean isSaslEnabled = false;
        if (System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, null) != null) {
            isSaslEnabled = true;
        }
        ZookeeperConnectionWatcher connectionWatcher = new ZookeeperConnectionWatcher(waitForConnection, isSaslEnabled);
        int zkSessionTimeoutMs = timeoutMs;
        ZooKeeper zookeeper = new ZooKeeper(zkConnectString, zkSessionTimeoutMs, (Watcher)connectionWatcher);
        boolean bl = timedOut = !waitForConnection.await(timeoutMs, TimeUnit.MILLISECONDS);
        if (timedOut) {
            String message = String.format("Timed out waiting for connection to Zookeeper. timeout(ms) = %s, Zookeeper connect = %s", timeoutMs, zkConnectString);
            throw new TimeoutException(message);
        }
        if (!connectionWatcher.isSuccessful()) {
            String message = String.format("Error occurred while connecting to Zookeeper server [%s]. %s", zkConnectString, connectionWatcher.getFailureMessage());
            throw new RuntimeException(message);
        }
        return zookeeper;
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static Map<String, String> getKafkaEndpointFromZookeeper(String zkConnectString, int timeoutMs) throws InterruptedException, IOException, KeeperException {
        List<String> brokerMetadata = ClusterStatus.getBrokerMetadataFromZookeeper(zkConnectString, timeoutMs);
        if (brokerMetadata.isEmpty()) {
            throw new RuntimeException("No brokers found in Zookeeper [" + zkConnectString + "] .");
        }
        String broker = brokerMetadata.get(0);
        HashMap<String, String> endpointMap = new HashMap<String, String>();
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map parsedBroker = (Map)gson.fromJson(broker, type);
        for (String rawEndpoint : (List)parsedBroker.get("endpoints")) {
            String[] protocolAddress = rawEndpoint.split("://");
            String protocol = protocolAddress[0];
            String address = protocolAddress[1];
            endpointMap.put(protocol, address);
        }
        return endpointMap;
    }
}

